/**
 */
package org.etsi.mts.tdl.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.library.collection.CollectionIsEmptyOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionLastOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberReference;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.tdlTables;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Parameter Binding</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.etsi.mts.tdl.impl.ParameterBindingImpl#getDataUse <em>Data Use</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.ParameterBindingImpl#getParameter <em>Parameter</em>}</li>
 *   <li>{@link org.etsi.mts.tdl.impl.ParameterBindingImpl#getReduction <em>Reduction</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ParameterBindingImpl extends ElementImpl implements ParameterBinding
{
	/**
	 * The cached value of the '{@link #getDataUse() <em>Data Use</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataUse()
	 * @generated
	 * @ordered
	 */
	protected DataUse dataUse;

	/**
	 * The cached value of the '{@link #getParameter() <em>Parameter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameter()
	 * @generated
	 * @ordered
	 */
	protected Parameter parameter;

	/**
	 * The cached value of the '{@link #getReduction() <em>Reduction</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReduction()
	 * @generated
	 * @ordered
	 */
	protected EList<MemberReference> reduction;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterBindingImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return tdlPackage.Literals.PARAMETER_BINDING;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataUse getDataUse()
	{
		return dataUse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDataUse(DataUse newDataUse, NotificationChain msgs)
	{
		DataUse oldDataUse = dataUse;
		dataUse = newDataUse;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, tdlPackage.PARAMETER_BINDING__DATA_USE, oldDataUse, newDataUse);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDataUse(DataUse newDataUse)
	{
		if (newDataUse != dataUse) {
			NotificationChain msgs = null;
			if (dataUse != null)
				msgs = ((InternalEObject)dataUse).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - tdlPackage.PARAMETER_BINDING__DATA_USE, null, msgs);
			if (newDataUse != null)
				msgs = ((InternalEObject)newDataUse).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - tdlPackage.PARAMETER_BINDING__DATA_USE, null, msgs);
			msgs = basicSetDataUse(newDataUse, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.PARAMETER_BINDING__DATA_USE, newDataUse, newDataUse));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Parameter getParameter()
	{
		if (parameter != null && parameter.eIsProxy()) {
			InternalEObject oldParameter = (InternalEObject)parameter;
			parameter = (Parameter)eResolveProxy(oldParameter);
			if (parameter != oldParameter) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, tdlPackage.PARAMETER_BINDING__PARAMETER, oldParameter, parameter));
			}
		}
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Parameter basicGetParameter()
	{
		return parameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParameter(Parameter newParameter)
	{
		Parameter oldParameter = parameter;
		parameter = newParameter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, tdlPackage.PARAMETER_BINDING__PARAMETER, oldParameter, parameter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MemberReference> getReduction()
	{
		if (reduction == null) {
			reduction = new EObjectContainmentEList<MemberReference>(MemberReference.class, this, tdlPackage.PARAMETER_BINDING__REDUCTION);
		}
		return reduction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DataType resolveParameterType()
	{
		/**
		 *
		 * if self.reduction->isEmpty()
		 * then self.parameter.dataType
		 * else
		 *   if self.reduction->last().member.oclIsUndefined()
		 *   then
		 *     if self.reduction->last().collectionIndex.oclIsUndefined()
		 *     then self.parameter.dataType
		 *     else
		 *       self.parameter.dataType.oclAsType(CollectionDataType).itemType
		 *     endif
		 *   else self.reduction->last().member.dataType
		 *   endif
		 * endif
		 */
		final /*@NonInvalid*/ Executor executor = PivotUtil.getExecutor(this);
		final /*@NonInvalid*/ IdResolver idResolver = executor.getIdResolver();
		final /*@NonInvalid*/ List<MemberReference> reduction = this.getReduction();
		final /*@NonInvalid*/ OrderedSetValue BOXED_reduction = idResolver.createOrderedSetOfAll(tdlTables.ORD_CLSSid_MemberReference, reduction);
		final /*@NonInvalid*/ boolean isEmpty = CollectionIsEmptyOperation.INSTANCE.evaluate(BOXED_reduction).booleanValue();
		/*@Thrown*/ DataType local_2;
		if (isEmpty) {
			final /*@NonInvalid*/ Parameter parameter = this.getParameter();
			final /*@NonInvalid*/ DataType dataType = parameter.getDataType();
			local_2 = dataType;
		}
		else {
			/*@Caught*/ Object CAUGHT_member;
			try {
				final /*@Thrown*/ MemberReference last = (MemberReference)OrderedCollectionLastOperation.INSTANCE.evaluate(BOXED_reduction);
				if (last == null) {
					throw new InvalidValueException("Null source for \'\'http://www.etsi.org/spec/TDL/1.4.1\'::MemberReference::member\'");
				}
				final /*@Thrown*/ Member member = last.getMember();
				CAUGHT_member = member;
			}
			catch (Exception e) {
				CAUGHT_member = ValueUtil.createInvalidValue(e);
			}
			final /*@NonInvalid*/ boolean oclIsUndefined = (CAUGHT_member == null) || (CAUGHT_member instanceof InvalidValueException);
			/*@Thrown*/ DataType local_1;
			if (oclIsUndefined) {
				final /*@NonInvalid*/ Parameter parameter_0 = this.getParameter();
				final /*@NonInvalid*/ DataType dataType_0 = parameter_0.getDataType();
				/*@Caught*/ Object CAUGHT_collectionIndex;
				try {
					final /*@Thrown*/ MemberReference last_0 = (MemberReference)OrderedCollectionLastOperation.INSTANCE.evaluate(BOXED_reduction);
					if (last_0 == null) {
						throw new InvalidValueException("Null source for \'\'http://www.etsi.org/spec/TDL/1.4.1\'::MemberReference::collectionIndex\'");
					}
					final /*@Thrown*/ DataUse collectionIndex = last_0.getCollectionIndex();
					CAUGHT_collectionIndex = collectionIndex;
				}
				catch (Exception e) {
					CAUGHT_collectionIndex = ValueUtil.createInvalidValue(e);
				}
				final /*@NonInvalid*/ boolean oclIsUndefined_0 = (CAUGHT_collectionIndex == null) || (CAUGHT_collectionIndex instanceof InvalidValueException);
				/*@Thrown*/ DataType local_0;
				if (oclIsUndefined_0) {
					local_0 = dataType_0;
				}
				else {
					final /*@NonInvalid*/ org.eclipse.ocl.pivot.Class TYP_tdl_c_c_CollectionDataType_0 = idResolver.getClass(tdlTables.CLSSid_CollectionDataType, null);
					final /*@Thrown*/ CollectionDataType oclAsType = (CollectionDataType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, dataType_0, TYP_tdl_c_c_CollectionDataType_0);
					final /*@Thrown*/ DataType itemType = oclAsType.getItemType();
					local_0 = itemType;
				}
				local_1 = local_0;
			}
			else {
				final /*@Thrown*/ MemberReference last_1 = (MemberReference)OrderedCollectionLastOperation.INSTANCE.evaluate(BOXED_reduction);
				if (last_1 == null) {
					throw new InvalidValueException("Null source for \'\'http://www.etsi.org/spec/TDL/1.4.1\'::MemberReference::member\'");
				}
				final /*@Thrown*/ Member member_0 = last_1.getMember();
				if (member_0 == null) {
					throw new InvalidValueException("Null source for \'\'http://www.etsi.org/spec/TDL/1.4.1\'::Parameter::dataType\'");
				}
				final /*@Thrown*/ DataType dataType_2 = member_0.getDataType();
				local_1 = dataType_2;
			}
			local_2 = local_1;
		}
		return local_2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID) {
			case tdlPackage.PARAMETER_BINDING__DATA_USE:
				return basicSetDataUse(null, msgs);
			case tdlPackage.PARAMETER_BINDING__REDUCTION:
				return ((InternalEList<?>)getReduction()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID) {
			case tdlPackage.PARAMETER_BINDING__DATA_USE:
				return getDataUse();
			case tdlPackage.PARAMETER_BINDING__PARAMETER:
				if (resolve) return getParameter();
				return basicGetParameter();
			case tdlPackage.PARAMETER_BINDING__REDUCTION:
				return getReduction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID) {
			case tdlPackage.PARAMETER_BINDING__DATA_USE:
				setDataUse((DataUse)newValue);
				return;
			case tdlPackage.PARAMETER_BINDING__PARAMETER:
				setParameter((Parameter)newValue);
				return;
			case tdlPackage.PARAMETER_BINDING__REDUCTION:
				getReduction().clear();
				getReduction().addAll((Collection<? extends MemberReference>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID) {
			case tdlPackage.PARAMETER_BINDING__DATA_USE:
				setDataUse((DataUse)null);
				return;
			case tdlPackage.PARAMETER_BINDING__PARAMETER:
				setParameter((Parameter)null);
				return;
			case tdlPackage.PARAMETER_BINDING__REDUCTION:
				getReduction().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID) {
			case tdlPackage.PARAMETER_BINDING__DATA_USE:
				return dataUse != null;
			case tdlPackage.PARAMETER_BINDING__PARAMETER:
				return parameter != null;
			case tdlPackage.PARAMETER_BINDING__REDUCTION:
				return reduction != null && !reduction.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
	{
		switch (operationID) {
			case tdlPackage.PARAMETER_BINDING___RESOLVE_PARAMETER_TYPE:
				return resolveParameterType();
		}
		return super.eInvoke(operationID, arguments);
	}

} //ParameterBindingImpl
