package org.etsi.mts.tdl.execution.java.rt.core;

public class Timer extends NamedElementImpl {
	
	private TimeUnit unit;

	private TimeLabel startLabel = new TimeLabel();
	
	private long period = 0L;
	
	public Timer(TimeUnit defaultUnit, String name, String qualifiedName) {
		super(name, qualifiedName);
		this.unit = defaultUnit;
		if (this.unit == null)
			this.unit = TimeUnit.Second;
		this.startLabel.setUnit(this.unit);
	}
	
	public TimeUnit getUnit() {
		return unit;
	}
	
	public long getPeriod() {
		return period;
	}
	
	public void start(long period) {
		start(period, this.unit);
	}
	
	public void stop() {
		// Nothing to do?
	}
	
	public void start(long period, TimeUnit unit) {
		this.period = period;
		this.unit = unit;
		this.startLabel.timestamp();
	}
	
	TimeLabel getStartLabel() {
		startLabel.setUnit(this.unit);
		return startLabel;
	}
}
