package org.etsi.mts.tdl.execution.java.rt.core;

public enum TimeUnit {
	Second, MilliSecond, NanoSecond;
	
	public static TimeUnit getByName(String name) {
		for (TimeUnit unit: TimeUnit.values()) {
			if (unit.toString().equals(name))
				return unit;
		}
		return null;
	}

	public long toMillis(long time) {
		return time * getNsDenominator() / MilliSecond.getNsDenominator();
	}

	public long toSeconds(long time) {
		return time * getNsDenominator() / Second.getNsDenominator();
	}
	
	int getNsDenominator() {
		switch (this) {
		case Second:
			return 1000000000;
		case MilliSecond:
			return 1000000;
		case NanoSecond:
			return 1;
		default:
			throw new RuntimeException("Missing Time unit denominator for " + this);
		}
	}
	
	public long convertTo(long time, TimeUnit target) {
		return time * getNsDenominator() / target.getNsDenominator();
	}
}