# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import logging, inspect

def send_response(result, message=None, code=None, data=None):
    """
    Generate and send a standardized API response.

    Args:
        result (bool): Indicates success or failure. Defaults to None.
        message (str, optional): Message (success or error). Defaults to None.
        code (int, optional): HTTP code (default 200 for success, 400 for error). Defaults to None.
        data (dict, optional): Additional payload. Defaults to None.

    Returns:
        tuple: (response_dict, http_status_code)
    """
    
    frame = inspect.currentframe().f_back
    filename = frame.f_code.co_filename
    lineno = frame.f_lineno

    if result:
        code = code or 200
        response = {
            "success": True,
            "data": data or {},
            "error": None,
        }
    else:
        code = code or 400
        error_info = f"{message or 'An error occurred while processing the request.'} (File: {filename}, Line: {lineno})"
        logging.warning(f"Request failed. Reason: {message}")
        response = {
            "success": False,
            "data": None,
            "error": error_info,
        }

    return response, code