# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

def safe_get(dct, keys):
    """
    Safely retrieves a nested value from a dictionary or list.
    Args:
        dct (dict or list): The dictionary or list to traverse.
        keys (list): A list of keys (for dicts) or indices (for lists) to follow.
    Returns:
        The value found at the nested location, or None if any key/index is not found.
    """
    for key in keys:
        if isinstance(dct, dict) and key in dct:
            dct = dct[key]
        elif isinstance(dct, list) and isinstance(key, int) and key < len(dct):
            dct = dct[key]
        else:
            return None
    return dct
