# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import logging, json
from .send_response import send_response

def load_template(dir_t):
    """
    Load and process JSON templates for different network slice formats.

    Args:
        dir_t (str): Path to the template file

    Returns:
        dict: Parsed JSON template
    """
    try:
        with open(dir_t, "r") as source:
            template = json.loads(
                source.read()
                .replace("\t", "")
                .replace("\n", "")
                .replace("'", '"')
                .strip()
            )
        return template
    except Exception as e:
        logging.error(f"Template loading error: {e}")
        return send_response(False, code=500, message=f"Template loading error: {e}")