# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

from .helpers.NEII_V4 import NEII_controller

def ixia_connect(requests, ixia_ip):
    """
    Connect to the IXIA NEII controller and send the requests.
    
    Args:
        requests (dict): IXIA NEII requests
        ixia_ip (str): IXIA NEII controller IP address
    
    Returns:
        response (requests.Response): Response from the IXIA NEII controller
    """
    response = None
    neii_controller = NEII_controller(ixia_ip)
    for intent in requests["services"]:
        # Send each separate IXIA request
        response = neii_controller.nscNEII(intent)
    return response