# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import logging
from .service_types.del_l3ipowdm_slice import del_l3ipowdm_slice
from .service_types.l3ipowdm_slice import l3ipowdm_slice

def e2e(ietf_intent, way=None, response=None, rules = None):
    logging.debug(f"E2E Realizer selected: {way}")
    if   way == "L3oWDM":     realizing_request = l3ipowdm_slice(rules)
    elif way == "DEL_L3oWDM": realizing_request = del_l3ipowdm_slice(rules, response)
    else:
        logging.warning(f"Unsupported way: {way}.")
        realizing_request = None
    return realizing_request