# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file includes original contributions from Telefonica Innovación Digital S.L.

from pathlib import Path
import os

# Default port for NSC deployment
NSC_PORT = os.getenv("NSC_PORT", "8081")

# Paths
BASE_DIR = Path(__file__).resolve().parent.parent.parent
SRC_PATH = BASE_DIR / "src"
TEMPLATES_PATH = SRC_PATH / "templates"
DATABASE_PATH = SRC_PATH / "database"
CONFIG_PATH = SRC_PATH / "config"
NBI_L2_PATH = "restconf/data/ietf-l2vpn-svc:l2vpn-svc/vpn-services"
NBI_L3_PATH = "restconf/data/ietf-l3vpn-svc:l3vpn-svc/vpn-services"



