# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import os
from dotenv import load_dotenv
from flask import Flask
import logging

# Load .env file if present
load_dotenv()

LOG_LEVELS = {
    "CRITICAL": logging.CRITICAL,
    "ERROR": logging.ERROR,
    "WARNING": logging.WARNING,
    "INFO": logging.INFO,
    "DEBUG": logging.DEBUG,
    "NOTSET": logging.NOTSET,
}

def create_config(app: Flask):
    """Load flags into Flask app.config"""
    # Default logging level
    app.config["LOGGING_LEVEL"] = LOG_LEVELS.get(os.getenv("LOGGING_LEVEL", "INFO").upper(),logging.INFO)

    # Dump templates
    app.config["DUMP_TEMPLATES"] = os.getenv("DUMP_TEMPLATES", "false").lower() == "true"

    # Mapper
    app.config["NRP_ENABLED"] = os.getenv("NRP_ENABLED", "false").lower() == "true"
    app.config["PLANNER_ENABLED"] = os.getenv("PLANNER_ENABLED", "false").lower() == "true"
    app.config["PLANNER_TYPE"] = os.getenv("PLANNER_TYPE", "ENERGY")
    app.config["PCE_EXTERNAL"] = os.getenv("PCE_EXTERNAL", "false").lower() == "true"
    app.config["HRAT_IP"] = os.getenv("HRAT_IP", "192.168.1.143")
    app.config["OPTICAL_PLANNER_IP"] = os.getenv("OPTICAL_PLANNER_IP", "10.30.7.66")

    # Realizer
    app.config["DUMMY_MODE"] = os.getenv("DUMMY_MODE", "true").lower() == "true"

    # Teraflow
    app.config["TFS_IP"] = os.getenv("TFS_IP", "127.0.0.1")
    app.config["UPLOAD_TYPE"] = os.getenv("UPLOAD_TYPE", "WEBUI")
    app.config["TFS_L2VPN_SUPPORT"] = os.getenv("TFS_L2VPN_SUPPORT", "false").lower() == "true"

    # IXIA
    app.config["IXIA_IP"] = os.getenv("IXIA_IP", "127.0.0.1")

    # E2E Controller
    app.config["TFS_E2E_IP"] = os.getenv("TFS_E2E_IP", "127.0.0.1")

    # WebUI
    app.config["WEBUI_DEPLOY"] = os.getenv("WEBUI_DEPLOY", "false").lower() == "true"

    return app
