#!/bin/bash

# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

# Container name
CONTAINER_NAME=nsc

# Verify if docker is active
if ! docker info > /dev/null 2>&1; then
    echo "Error: Docker not running. Please, restart Docker service and try again."
    exit 1
fi

# Stop container if running
echo "Verify if '$CONTAINER_NAME' is running..."
if [ $(docker ps -q -f name=$CONTAINER_NAME) ]; then
    echo "Stopping current container '$CONTAINER_NAME'..."
    docker stop $CONTAINER_NAME
fi

# Cleaning residual containers and images
echo "Cleaning old Docker containers and images..."
docker container prune -f
docker image prune -f

# Verificar que .env.example existe
if [ ! -f src/config/.env.example ]; then
    echo "Error: .env.example not found"
    exit 1
fi

# Copy .env.example to .env
echo "Generating .env file..."
cp src/config/.env.example .env

# Read NSC_PORT from .env
NSC_PORT=$(grep '^NSC_PORT=' .env | cut -d '=' -f2)

# Docker build
echo "Building docker image..."
docker build -t nsc .

# Executing nsc
echo "Running nsc on port $NSC_PORT..."
docker run -d --env-file .env -p $NSC_PORT:$NSC_PORT --name $CONTAINER_NAME $CONTAINER_NAME
echo "---READY---"
