import pytest

# Importa tu clase (ajusta el nombre del módulo si es distinto)
from src.main import NSController  

def test_init_default_values():
    """Test that default initialization sets expected values."""
    controller = NSController()

    # Atributo configurable
    assert controller.controller_type == "TFS"

    # Atributos internos
    assert controller.path == ""
    assert controller.response == []
    assert controller.start_time == 0
    assert controller.end_time == 0
    assert controller.setup_time == 0

@pytest.mark.parametrize("controller_type", ["TFS", "IXIA", "custom"])
def test_init_controller_type(controller_type):
    """Test initialization with different controller types."""
    controller = NSController(controller_type=controller_type)
    assert controller.controller_type == controller_type

def test_init_independence_between_instances():
    """Test that each instance has independent state (mutable attrs)."""
    c1 = NSController()
    c2 = NSController()

    # Modifico una lista en una instancia
    c1.response.append("test-response")

    # La otra instancia no debería verse afectada
    assert c2.response == []
    assert c1.response == ["test-response"]

