# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import logging
from .service_types.tfs_l2vpn import tfs_l2vpn
from .service_types.tfs_l3vpn import tfs_l3vpn

def tfs(ietf_intent, way=None, response=None):
    """
    Generates a TFS realizing request based on the specified way (L2 or L3).

    Args:
        ietf_intent (dict): The IETF intent to be realized. Defaults to None.
        way (str): The type of service to realize ("L2" or "L3"). Defaults to None.
        response (dict): Response built for user feedback. Defaults to None.
        
    Returns:
        dict: A realization request for the specified network slice type.
    """
    if way == "L2":
        realizing_request = tfs_l2vpn(ietf_intent, response)
    elif way == "L3":
        realizing_request = tfs_l3vpn(ietf_intent, response)
    else:
        logging.warning(f"Unsupported way: {way}. Defaulting to L2 realization.")
        realizing_request = tfs_l2vpn(ietf_intent, response)
    return realizing_request