# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

import logging, os, json
from src.config.constants import DATABASE_PATH

def nrp_handler(request, nrp):
    """
    Manage Network Resource Partition (NRP) operations.

    This method handles CRUD operations for Network Resource Partitions,
    interacting with Network Controllers (currently done statically via a JSON-based database file).

    Args:
        request (str): The type of operation to perform. 
            Supported values:
            - "CREATE": Add a new NRP to the database
            - "READ": Retrieve the current NRP view
            - "UPDATE": Update an existing NRP (currently a placeholder)

        nrp (dict): The Network Resource Partition details to create or update.

    Returns:
        None or answer: 
        - For "CREATE": Returns the response from the controller (currently using a static JSON)
        - For "READ": Gets the NRP view from the controller (currently using a static JSON)
        - For "UPDATE": Placeholder for update functionality

    Notes:
        - Uses a local JSON file "nrp_ddbb.json" to store NRP information as controller operation is not yet defined
    """
    if request == "CREATE":
        # TODO: Implement actual request to Controller to create an NRP
        logging.debug("Creating NRP")

        # Load existing NRP database
        with open(os.path.join(DATABASE_PATH, "nrp_ddbb.json"), "r") as archivo:
            nrp_view = json.load(archivo)

        # Append new NRP to the view
        nrp_view.append(nrp)

        # Placeholder for controller POST request
        answer = None
        return answer
    elif request == "READ":
        # TODO: Request to Controller to get topology and current NRP view
        logging.debug("Reading Topology")

        # Load NRP database
        with open(os.path.join(DATABASE_PATH, "nrp_ddbb.json"), "r") as archivo:
            # self.__nrp_view = json.load(archivo)
            nrp_view = json.load(archivo)
            return nrp_view
        
    elif request == "UPDATE":
        # TODO: Implement request to Controller to update NRP
        logging.debug("Updating NRP")
        answer = ""