# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

from ..tfs.helpers.tfs_connector import tfs_connector

def e2e_connect(requests, controller_ip):
    """ 
    Function to connect end-to-end services in TeraFlowSDN (TFS) controller.
    
    Args:
        requests (list): List of requests to be sent to the TFS e2e controller.
        controller_ip (str): IP address of the TFS e2e controller.
    """
    response = tfs_connector().webui_post(controller_ip, requests)
    return response