# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

def detect_format(json_data):    
    """
    Detect the format of the input network slice intent.

    This method identifies whether the input JSON is in 3GPP or IETF format 
    by checking for specific keys in the JSON structure.

    Args:
        json_data (dict): Input network slice intent JSON

    Returns:
        str or None: 
            - "IETF" if IETF-specific keys are found
            - "3GPP" if 3GPP-specific keys are found
            - None if no recognizable format is detected
    """
    # Check for IETF-specific key
    if "ietf-network-slice-service:network-slice-services" in json_data:
        return "IETF"
    # Check for 3GPP-specific keys
    if any(key in json_data for key in ["NetworkSlice1", "TopSliceSubnet1", "CNSliceSubnet1", "RANSliceSubnet1"]):
        return "3GPP"
    
    return None