# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

from src.database.db import save_data, update_data

def store_data(intent, slice_id, controller_type=None):
    """
    Store network slice intent information in a JSON database file.

    This method:
    1. Creates a JSON file if it doesn't exist
    2. Reads existing content
    3. Updates or adds new slice intent information

    Args:
        intent (dict): Network slice intent to be stored
        slice_id (str, optional): Existing slice ID to update. Defaults to None.
    """
    # Update or add new slice intent
    if slice_id:
        update_data(slice_id, intent, controller_type)
    else:
        # Add new slice intent
        slice_id = intent["ietf-network-slice-service:network-slice-services"]["slice-service"][0]["id"]
        save_data(slice_id, intent, controller_type)