#!/bin/bash

# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file is an original contribution from Telefonica Innovación Digital S.L.

rm -rf ./report

echo "Dumping NSC templates..."
mkdir ./report

copied=0

for file in nbi_template.json ietf_template.json realizer_template.json; do
  if docker cp nsc:/app/src/templates/$file ./report/ 2>/dev/null; then
    echo "Copied $file"
    ((copied++))
  else
    echo "⚠️  $file not found in container"
  fi
done

if [ "$copied" -eq 0 ]; then
  echo "No templates were copied. Removing ./report"
  rm -rf ./report
  exit 1
fi

echo "$copied template(s) dumped in ./report"