- [Run All CAPIF Services locally with Docker images](#run-all-capif-services-locally-with-docker-images)
- [Run All CAPIF Services locally with Docker images and deploy monitoring stack](#run-all-capif-services-locally-with-docker-images-and-deploy-monitoring-stack)
- [Run each service using Docker](#run-each-service-using-docker)
- [Run each service using Python](#run-each-service-using-python)

Capif services are developed under [services folder](https://labs.etsi.org/rep/ocf/capif/-/tree/main/services).

### Run All CAPIF Services locally with Docker images
To run using docker and docker compose, version 2.10 or higher, you must ensure you have those tools installed in your machine. Also to simplify the process, we have 3 scripts allowing docker images to deploy, check and cleanup.

All these scripts are available under ***services*** directory.

To run CAPIF APIs locally using docker and docker-compose you can use run.sh script:
```
./run.sh -h

Usage: ./run.sh <options>
       -c : Setup different hostname for capif
       -m : Clean monitoring service
       -h : show this help
```
This script builds and runs all services using docker images, including mongodb and nginx locally and in the background, and imports ca.crt to nginx. By default monitoring is not activated and Nginx is deployed use **capifcore** as a hostname. 

Some examples of use:
```
# Default values, No monitoring and capifcore as CAPIF_HOSTNAME
./run.sh

# opencapif.etsi.org as CAPIF_HOSTNAME
./run.sh -c opencapif.etsi.org

# opencapif.etsi.org as CAPIF_HOSTNAME and monitoring activated
./run.sh -c opencapif.etsi.org -m true 

```

If you want to check if all CAPIF services are running properly in a local machine after executing run.sh, you can use:
```
./check_services_are_running.sh
```
This shell script will return 0 if all services are running properly.

When we need to stop all CAPIF services, we can use next bash script:
```
./clean_capif_docker_services.sh -a
```

NOTE: You can use different flags if you only want to stop some of them, please check the help using
```
./clean_capif_docker_services.sh -h

Usage: clean_capif_docker_services.sh <options>
       -c : clean capif services
       -v : clean vault service
       -r : clean register service
       -m : clean monitoring service
       -a : clean all services
       -h : show this help
```

This shell script will remove and clean all CAPIF services started previously with run.sh

On the other hand you can check logs using show_logs.sh script, please check options:
```
./show_logs.sh
You must specify an option when running the script.
Usage: ./show_logs.sh <options>
       -c : Show capif services
       -v : Show vault service
       -r : Show register service
       -m : Show monitoring service
       -a : Show all services
       -f : Follow log output
       -h : Show this help
```
You can also use option -f in order to follow log output in real time

### Run All CAPIF Services locally with Docker images and deploy monitoring stack
It is now possible to deploy a monitoring stack for CAPIF with Grafana, Prometheus, FluentBit, Loki, Cadvisor, Tempo and Opentelemetry.

To deploy CAPIF together with the monitoring stack, it is only necessary to execute the following.

```
./run.sh -m true
```

After they have been built, the different panels can be consulted in Grafana at the url

```
http://localhost:3000
```

By default, the monitoring option is set to false. Once up, all data sources and dashboards are automatically provisioned.

### Run each service using Docker

Also you can run OpenCAPIF service by service using docker:
```
cd <Service>
docker build -t capif_security .
docker run -p 8080:8080 capif_security
```

### Run each service using Python

Run using python
```
cd <Service>
pip3 install -r requirements.txt
python3 -m <service>
```