## **2.1. Configure Environment**



### **2.1.1. Python**

This section describes how to configure the Python environment to run experiments and 
develop code for the ETSI TeraFlowSDN controller.
In particular, we use [PyEnv](https://github.com/pyenv/pyenv) to install the appropriate 
version of Python and manage the virtual environments.

<h3><u>Upgrade the Ubuntu distribution</h3></u>

Skip this step if you already did it during the installation of your machine.
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```


<h3><u>Install PyEnv dependencies</h3></u>
```bash
sudo apt-get install -y make build-essential libssl-dev zlib1g-dev libbz2-dev libreadline-dev libsqlite3-dev wget \
    curl llvm git libncursesw5-dev xz-utils tk-dev libxml2-dev libxmlsec1-dev libffi-dev liblzma-dev
```


<h3><u>Install PyEnv</h3></u>

We recommend installing PyEnv through  
[PyEnv Installer](https://github.com/pyenv/pyenv-installer).
Below you can find the instructions, but we refer you to the link for updated 
instructions.

```bash
curl https://pyenv.run | bash
# When finished, edit ~/.bash_profile // ~/.profile // ~/.bashrc as the installer proposes.
# In general, it means to append the following lines to ~/.bashrc:
export PYENV_ROOT="$HOME/.pyenv"
command -v pyenv >/dev/null || export PATH="$PYENV_ROOT/bin:$PATH"
eval "$(pyenv init -)"
eval "$(pyenv virtualenv-init -)"
```

In case .bashrc is not linked properly to your profile, you may need to append the 
following line into your local .profile file:

```bash
# Open ~/.profile and append this line:
+source "$HOME"/.bashrc
```


<h3><u>Restart the machine</h3></u>
Restart the machine for all the changes to take effect.
```bash
sudo reboot
```


<h3><u>Install Python 3.9 over PyEnv</h3></u>

ETSI TeraFlowSDN uses Python 3.9 by default.
You should install the latest stable update of Python 3.9, i.e., avoid "-dev" versions.
To find the latest version available in PyEnv, you can run the following command:

```bash
pyenv install --list | grep " 3.9"
```

At the time of writing, this command will output the following list:

```
  3.9.0
  3.9-dev
  3.9.1
  3.9.2
  3.9.4
  3.9.5
  3.9.6
  3.9.7
  3.9.8
  3.9.9
  3.9.10
  3.9.11
  3.9.12
  3.9.13
  3.9.14 
  3.9.15
  3.9.16 ** always select the latest version **
```

Therefore, the latest stable version is Python 3.9.16.
To install this version, you should run:

```bash
pyenv install 3.9.16
    # This command might take some minutes depending on your Internet connection speed 
    # and the performance of your machine.
```


<h3><u>Create the Virtual Environment for TeraFlowSDN</h3></u>
The following commands create a virtual environment named as `tfs` using Python 3.9 and 
associate that environment with the current folder, i.e., `~/tfs-ctrl`.
That way, when you are in that folder, the associated virtual environment will be used, 
thus inheriting the Python interpreter, i.e., Python 3.9, and the Python packages 
installed on it.

```bash
cd ~/tfs-ctrl
pyenv virtualenv 3.9.16 tfs
pyenv local 3.9.16/envs/tfs
```

After completing these commands, you should see in your prompt that now you're within 
the virtual environment `3.9.16/envs/tfs` on folder `~/tfs-ctrl`:

```
(3.9.16/envs/tfs) tfs@tfs-vm:~/tfs-ctrl$
```

In case that the correct pyenv does not get automatically activated when you change to 
the tfs-ctrl/ folder, then execute the following command:

```bash
cd ~/tfs-ctrl
pyenv activate 3.9.16/envs/tfs
```



<h3><u>Install the basic Python packages within the virtual environment</h3></u>
From within the `3.9.16/envs/tfs` environment on folder `~/tfs-ctrl`, run the following 
commands to install the basic Python packages required to work with TeraFlowSDN.
```bash
cd ~/tfs-ctrl
./install_requirements.sh
```

Some dependencies require to re-load the session, so log-out and log-in again.


<h3><u>Generate the Python code from the gRPC Proto messages and services</h3></u>

The components, e.g., microservices, of the TeraFlowSDN controller, in general, use a gRPC-based open API to interoperate.
All the protocol definitions can be found in sub-folder `proto` within the root project folder.
For additional details on gRPC, visit the official web-page [gRPC](https://grpc.io/).

In order to interact with the components, (re-)generate the Python code from gRPC definitions running the following command:

```bash
cd ~/tfs-ctrl
proto/generate_code_python.sh
```

### **2.1.2. Java (Quarkus)**

This section describe the steps needed to create a development environment for TFS components implemented in Java. Currently, ZTP and Policy components have been developed in Java (version 11) and use the [Quarkus](https://quarkus.io/) framework, which enables kubernetes-native development.

<h3><u>Install JDK</h3></u>
To begin, make sure that you have java installed and in the correct version
```
java --version
```

If you don't have java installed you will get an error like the following:
```
Command 'java' not found, but can be installed with:

sudo apt install default-jre              # version 2:1.11-72build1, or
sudo apt install openjdk-11-jre-headless  # version 11.0.14+9-0ubuntu2
sudo apt install openjdk-17-jre-headless  # version 17.0.2+8-1
sudo apt install openjdk-18-jre-headless  # version 18~36ea-1
sudo apt install openjdk-8-jre-headless   # version 8u312-b07-0ubuntu1
```

In which case you should use the following command to install the correct version:
```
sudo apt install openjdk-11-jre-headless
```

Else you should get something like the following:
```
openjdk 11.0.18 2023-01-17
OpenJDK Runtime Environment (build 11.0.18+10-post-Ubuntu-0ubuntu120.04.1)
OpenJDK 64-Bit Server VM (build 11.0.18+10-post-Ubuntu-0ubuntu120.04.1, mixed mode, sharing)
```

<h3><u>Compiling and testing existing components</h3></u>
In the root directory of the existing Java components you will find an executable maven wrapper named `mvnw`. You could use this executable, which is already configured in pair with the components, instead of your local maven installation. So for example if you want to compile the project you would run the following:
```
./mvnw compile
```

<h3><u>VS Code Quarkus plugin</h3></u>
In case you are using [VS Code](https://code.visualstudio.com/) for development, we suggest to install the [official Quarkus extension](https://marketplace.visualstudio.com/items?itemName=redhat.vscode-quarkus).
The extension should be able to automatically find the current open project and integrate with the above `mvnw` maven wrapper, making it easier to control the [maven lifecycle](https://maven.apache.org/guides/introduction/introduction-to-the-lifecycle.html).
Make sure that you open the specific component directory (i.e., `src/ztp` or `src/policy`) and not the general controller one (i.e., `src`.

<h3><u>New Java TFS component</h3></u>

**Sample Project**

If you want to create a new TFS component written in Java you could generate a new Quarkus project based on the following project:

[TFS Sample Quarkus Project](https://code.quarkus.io/?e=grpc&e=kubernetes&e=container-image-jib&e=kubernetes-service-binding&e=smallrye-health&e=resteasy-reactive)

In that way, you should have most of the libraries you would need to integrate with the rest of the TFS Components. Feel free however to add or remove libraries depending on your needs.

**Initial setup**

If you used the sample project above, you should have a project with a basic structure. However there are some steps that you should take before starting development.

First make sure that you copy the protobuff files, that are found in the root directory of the TFS SDN controller, to the `new-component/src/main/proto` directory.

Next you should create the following files:
* `new-component/.gitlab-ci.yml`
* `new-component/Dockerfile`
* `new-component/src/resources/application.yaml`

We suggest to copy the respective files from existing components (Automation and Policy) and change them according to your needs.

### **2.1.3. Java (Maven)**

**Page under construction**

### **2.1.4. Rust**

**Page under construction**

### **2.1.5. Erlang**

This section describes how to configure the Erlang environment to run experiments and
develop code for the ETSI TeraFlowSDN controller.

First we need to install Erlang. There is multiple way, for development we will be
using [ASDF](https://asdf-vm.com/), a tool that allows the installation of multiple
version of Erlang at the same time, and switch from one version to the other at will.

- First, install any missing dependencies:
```bash
sudo apt install curl git autoconf libncurses-dev build-essential m4 libssl-dev 
```

- Download *ASDF* tool to the local account:
```bash
git clone https://github.com/asdf-vm/asdf.git ~/.asdf --branch v0.10.2
```

- Make *ASDF* activate on login by adding these lines at the end of the `~/.bashrc` file:
```bash
. $HOME/.asdf/asdf.sh
. $HOME/.asdf/completions/asdf.bash
```

- Logout and log back in to activate *ASDF*.

*ASDF* supports multiple tools by installing there corresponding plugins.

- Install *ASDF* plugin for Erlang:
```bash
asdf plugin add erlang https://github.com/asdf-vm/asdf-erlang.git
```

- Install a version of Erlang:
```bash
asdf install erlang 24.3.4.2
```

- Activate Erlang locally for TFS controller. This will create a local file
called `.tool-versions` defining which version of the tools to use when
running under the current directory:
```bash
cd tfs-ctrl/
asdf local erlang 24.3.4.2
```

Erlang projects uses a build tool called
[rebar3](https://github.com/erlang/rebar3).
It is used to manager project dependenecies, compile a project and generate
project releases.

- Install rebar3 localy from source:
```bash
cd ~
git clone https://github.com/erlang/rebar3.git
cd rebar3
asdf local erlang 24.3.4.2
./bootstrap
./rebar3 local install
```

- Update `~/.bashrc` to use rebar3 by adding this line at the end:
```bash
export PATH=$HOME/.cache/rebar3/bin:$PATH
```

- Logout and log back in.

### **2.1.6. Kotlin**

<h2><u>Kotlin</h2></u>
This section describes the steps needed to establish a development environment for TFS (TeraFlowSDN) components implemented in Kotlin. Currently, the `Gateway` component stands as the sole component developed in Kotlin.

<h3><u>Install Kotlin</h3></u>
To begin, make sure that you have kotlin installed and its current version:
```
kotlin -version
```

If you don't have kotlin installed you will get an error like the following:
```
Command 'kotlin' not found, but can be installed with:
sudo snap install --classic kotlin
```
In which case you should use the following command to install the correct version:
```
 sudo snap install --classic kotlin
```

Currently, the recommended version is 1.6.21, which uses Java Runtime Environment (JRE) version 11.


<h3><u>Compiling and testing existing components</h3></u>
To compile a Kotlin project using Gradle, similarly to using the Maven wrapper (mvnw) for Java projects, you can use the Gradle wrapper (gradlew) within the root directory of your Kotlin component, specifically the gateway directory.

Navigate to the gateway directory within your Kotlin project. Ensure that it contains the gradlew script along with the gradle directory.
Then, create a directory named `proto` and move all the files with extension `.proto` in this way:

```
mkdir proto
cp ../../../proto/*.proto ./proto 
```
For building the application, open a terminal or command prompt, navigate to the gateway directory, and run the following command:
```
./gradlew build
```
The following program runs the gateway application:
```
./gradlew runServer 
```

<h3><u>New Kotlin TFS component</h3></u>

**Sample Project**

If you want to create a new TFS component written in Kotlin you could generate a Kotlin project using `gradle`. The recommended version is 7.1. Follow the following [Gradle guide](https://linuxize.com/post/how-to-install-gradle-on-ubuntu-20-04/) for its installation. For building the prokect follow [this link](https://docs.gradle.org/current/samples/sample_building_kotlin_applications.html) instead.

From inside the new project directory, run the init task using the following command in a terminal: `gradle init`. 

The output will look like this:

 
```
$ gradle init

Select type of project to generate:
  1: basic
  2: application
  3: library
  4: Gradle plugin
Enter selection (default: basic) [1..4] 2

Select implementation language:
  1: C++
  2: Groovy
  3: Java
  4: Kotlin
  5: Scala
  6: Swift
Enter selection (default: Java) [1..6] 4

Select build script DSL:
  1: Groovy
  2: Kotlin
Enter selection (default: Groovy) [1..2] 1

Project name (default: demo):
Source package (default: demo):


BUILD SUCCESSFUL
2 actionable tasks: 2 executed
```

**Initial setup**

The `gradle init` command generates the new project. 

First, ensure the protobuf files are copied from the root directory of the TFS SDN controller. Run the following command in the directory of the new project:

```
mkdir proto 
cp TFS/project/root/path/proto/*.proto ./proto/
```

The file `build.gradle.ktl` is fundamental as it manages dependencies. Adjust it for adding external libraries.  

Next you should create the following files:

1. `new-component/.gitlab-ci.yml`
1. `new-component/Dockerfile`


We recommend leveraging the structures and configurations found in the files of existing components for inspiration.

**Docker Container**
This project operates with Docker containers. Ensure the production of the container version for your component. To generate the container version of the project, modify the 'new-component/Dockerfile.' Execute the following command from the project's root directory:
```
docker build -t new-image -f new-component/Dockerfile ./
```
****

## **2.2. Configure VScode**

<h3><u>Install VSCode and the required extensions</h3></u>

If not already done, install [VSCode](https://code.visualstudio.com/) and the "Remote SSH" extension on your local
machine, not in the VM.

__Note__: "Python" extension is not required here. It will be installed later on the VSCode server running on the VM.


<h3><u>Configure the "Remote SSH" extension</h3></u>

- Go to left icon "Remote Explorer"
- Click the "gear" icon next to "SSH TARGETS" on top of "Remote Explorer" bar
- Choose to edit "<...>/.ssh/config" file (or equivalent)
- Add the following entry (assuming previous port forwarding configuration):
```
Host TFS-VM
    HostName 127.0.0.1
    Port 2200
    ForwardX11 no
    User tfs
```
- Save the file
- An entry "TFS-VM" should appear on "SSH TARGETS".


<h3><u>Connect VSCode to the VM through "Remote SSH" extension</h3></u>
- Right-click on "TFS-VM"
- Select "Connect to Host in Current Window"
- Reply to the questions asked
  - Platform of the remote host "TFS-VM": Linux
  - "TFS-VM" has fingerprint "<fingerprint>". Do you want to continue?: Continue
  - Type tfs user's password: tfs123
- You should be now connected to the TFS-VM.

__Note__: if you get a connection error message, the reason might be due to wrong SSH server fingerprint. Edit file
          "<...>/.ssh/known_hosts" on your local user account, check if there is a line starting with
          "[127.0.0.1]:2200" (assuming previous port forwarding configuration), remove the entire line, save the file,
          and retry connection.


<h3><u>Add SSH key to prevent typing the password every time</h3></u>
This step creates an SSH key in the VM and installs it on the VSCode to prevent having to type the password every time.

- In VSCode (connected to the VM), click menu "Terminal > New Terminal"
- Run the following commands on the VM's terminal through VSCode
```bash
ssh-keygen -t rsa -b 4096 -f ~/.ssh/tfs-vm.key
  # leave password empty
ssh-copy-id -i ~/.ssh/tfs-vm.key.pub tfs@10.0.2.10
  # tfs@10.0.2.10's password: <type tfs user's password: tfs123>
rm .ssh/known_hosts 
```

- In VSCode, click left "Explorer" panel to expand, if not expanded, and click "Open Folder" button.
  - Choose "/home/tfs/"
  - Type tfs user's password when asked
  - Trust authors of the "/home/tfs [SSH: TFS-VM]" folder when asked
- Right click on the file "tfs-vm.key" in the file explorer
  - Select "Download..." option
  - Download the file into your user's accout ".ssh" folder
- Delete files "tfs-vm.key" and "tfs-vm.key.pub" on the TFS-VM.

- In VSCode, click left "Remote Explorer" panel to expand
  - Click the "gear" icon next to "SSH TARGETS" on top of "Remote Explorer" bar
  - Choose to edit "<...>/.ssh/config" file (or equivalent)
  - Find entry "Host TFS-VM" and update it as follows:
```
Host TFS-VM
    HostName 127.0.0.1
    Port 2200
    ForwardX11 no
    User tfs
    IdentityFile "<path to the downloaded identity private key file>"
```
  - Save the file
- From now, VSCode will use the identity file to connect to the TFS-VM instead of the user's password.


<h3><u>Install VSCode Python Extension (in VSCode server)</h3></u>
This step installs Python extensions in VSCode server running in the VM.

- In VSCode (connected to the VM), click left button "Extensions"
- Search "Python" extension in the extension Marketplace.
- Install official "Python" extension released by Microsoft.
  - By default, since you're connected to the VM, it will be installed in the VSCode server running in the VM.

- In VSCode (connected to the VM), click left button "Explorer"
- Click "Ctrl+Alt+P" and type "Python: Select Interpreter". Select option "Python: 3.9.13 64-bit ('tfs')"


<h3><u>Define environment variables for VSCode</h3></u>
The source code in the TFS controller project is hosted in folder `src/`. To help VSCode find the Python modules and
packages, add the following file into your working space root folder:

```bash
echo "PYTHONPATH=./src" >> ~/tfs-ctrl/.env
```

## **2.3. Develop A Component (WIP)**

**Page under construction**
