This section walks you through the process of running experiments in TeraFlowSDN on top of a machine running MicroK8s Kubernetes platform.
The guide includes the details on configuring the Python environment, some basic commands you might need, configuring the network topology, and executing different experiments.

Note that the steps followed here are likely to work regardless of the platform where TeraFlowSDN is deployed over.

Note also that this guide will keep growing with the new experiments and demonstrations that are being carried out involving the ETSI TeraFlowSDN controller.

**Important:** The NBIs, workflows and drivers have to be considered as experimental. The configuration and monitoring capabilities they support are limited, partially implemented, or tested only with specific laboratory equipment. Use them with care.

- [3.1. OFC'22 Demo](#31-ofc22-demo)
    - Bootstrapping of devices
    - Monitoring of device endpoints
    - Management of L3VPN services
    - Integration with ETSI OpenSourceMANO

- [3.2. ECOC'22 Demo](#32-ecoc22-demo)
    - Disjoint DC-2-DC L2VPN Service management
    - Integration with ETSI OpenSourceMANO

- [3.3. OECC-PSC'22 Demo (Work In Progress)](#33-oecc-psc22-demo-work-in-progress)
    - Interdomain Slices

- [3.4. NFV-SDN'22 Demo (Work In Progress)](#34-nfv-sdn22-demo-work-in-progress)
    - DLT-based context sharing
    - DLT-based Interdomain Slices with SLAs

## **3.1. OFC'22 Demo**

This functional test reproduces the live demonstration *Demonstration of Zero-touch Device and L3-VPN Service Management Using the TeraFlow Cloud-native SDN Controller*  carried out at [OFC'22](https://ieeexplore.ieee.org/document/9748575) / [Open access](https://research.chalmers.se/en/publication/c397ef36-837f-416d-a44d-6d3b561d582a).

The main features demonstrated are:

- Bootstrapping of devices
- Monitoring of device endpoints
- Management of L3VPN services
- Integration with ETSI OpenSourceMANO


<h3><u>Functional test folder</h3></u>

This functional test can be found in folder `./src/tests/ofc22/`.


<h3><u>Execute with real devices</h3></u>

This functional test is designed to operate both with real and emulated devices.
By default, emulated devices are used; however, if you have access to real devices, you can create/modify the files `./src/tests/ofc22/tests/Objects.py` and `./src/tests/ofc22/tests/Credentials.py` to point to your devices, and map to your own network topology.
Otherwise, you can modify the `./src/tests/ofc22/tests/descriptors_emulated.json` that is designed to be uploaded through the WebUI instead of using the command line scripts.
Note that the default scenario assumes devices R2 and R4 are always emulated, while 
devices R1, R3, and O1 can be configured as emulated or real devices.

__Important__: The device drivers operating with real devices, e.g., OpenConfigDriver, 
               P4Driver, and TransportApiDriver, have to be considered as experimental. 
               The configuration and monitoring capabilities they support are
               limited or partially implemented/tested. Use them with care.


<h3><u>Deployment and Dependencies</h3></u>

To run this functional test, it is assumed you have deployed a MicroK8s-based Kubernetes environment and a TeraFlowSDN controller instance as described in the [Tutorial: Deployment Guide](https://tfs.etsi.org/documentation/develop/deployment_guide/), and you configured the Python environment as described in [Tutorial: Development Guide > Configure Environment > Python](https://tfs.etsi.org/documentation/develop/development_guide/#211-python).

<h3><u>Access to the WebUI and Dashboard</h3></u>

When the deployment completes, you can connect to the TeraFlowSDN WebUI and Dashboards as described in [Tutorial: Deployment Guide > WebUI and Grafana Dashboards](https://tfs.etsi.org/documentation/develop/deployment_guide/#14-webui-and-grafana-dashboards)

Notes:

- the default credentials for the Grafana Dashboiard is user/pass: `admin`/`admin123+`.
- in Grafana, you will find the *L3-Monitorng* in the *Starred dashboards* section.


<h3><u>Test execution</h3></u>

Before executing the tests, we need to prepare a few things.

First, you need to make sure that you have all the gRPC-generate code in your folder.
To do so, run:

```
proto/generate_code_python.sh
```

Then, it is time to deploy TeraFlowSDN with the correct specification for this scenario.
Make sure to load your deployment variables for this scenario by:

```
source src/tests/ofc22/deploy_specs.sh
```

Then, you need to deploy the components by running:

```
./deploy/all.sh
```

After the deployment is finished, you need to load the environment variables to support the execution of the tests by:

```
source tfs_runtime_env_vars.sh
```

To execute this functional test, four main steps needs to be carried out:

1. Device bootstrapping
2. L3VPN Service creation
3. L3VPN Service removal
4. Cleanup

Upon the execution of each test progresses, a report will be generated indicating *PASSED* / *FAILED* / *SKIPPED*. If there is some error during the execution, you should see a detailed report on the error. See the troubleshooting section if needed.

You can check the logs of the different components using the appropriate `scripts/show_logs_[component].sh` scripts after you execute each step.

There are two ways to execute the functional tests, *running all the tests with a single script* or *running each test independently*.
In the following we start with the first option, then we comment on how to run each test independently.


**Running all tests with a single script**

We have a script that executes all the steps at once.
It is meant for being used to test if all components involved in this scenario are working correct.
To run all the functional tests, you can run:

```
src/tests/ofc22/run_tests.sh
```

The following sections explain each one of the steps.


**Device bootstrapping**

This step configures some basic entities (Context and Topology), the devices, and the 
links in the topology.
The expected results are:

- The devices to be added into the Topology.
- The devices to be pre-configured and initialized as ENABLED by the Automation component.
- The monitoring for the device ports (named as endpoints in TeraFlowSDN) to be activated and data collection to automatically start.
- The links to be added to the topology.

To run this step, you can do it from the WebUI by uploading the file `./ofc22/tests/descriptors_emulated.json` that
contains the descriptors of the contexts, topologies, devices, and links, or by 
executing the script:

```
./src/tests/ofc22/run_test_01_bootstrap.sh
```

When the bootstrapping finishes, check in the Grafana L3-Monitoring Dashboard and you 
should see the monitoring data being plotted and updated every 5 seconds (by default). 
Given that there is no service configured, you should see a 0-valued flat plot.

In the WebUI, select the *admin* Context.
Then, in the *Devices* tab you should see that 5 different emulated devices have been 
created and activated: 4 packet routers, and 1 optical line system controller.
Besides, in the *Services* tab you should see that there is no service created.
Note here that the emulated devices produce synthetic randomly-generated monitoring data 
and do not represent any particular services configured.


**L3VPN Service creation**

This step configures a new service emulating the request an OSM WIM would make by means of a Mock OSM instance.

To run this step, execute the script:

```
./src/tests/ofc22/run_test_02_create_service.sh
```

When the script finishes, check the WebUI *Services* tab. You should see that two services have been created, one for the optical layer and another for the packet layer. 
Besides, you can check the *Devices* tab to see the configuration rules that have been configured in each device. In the Grafana Dashboard, given that there is now a service configured, you should see the plots with the monitored data for the device. By default, device R1-EMU is selected.


**L3VPN Service removal**

This step deconfigures the previously created services emulating the request an OSM WIM would make by means of a Mock OSM instance.

To run this step, execute the script:

```
./src/tests/ofc22/run_test_03_delete_service.sh
```

or delete the L3NM service from the WebUI.

When the script finishes, check the WebUI *Services* tab. You should see that the two services have been removed. Besides, in the *Devices* tab you can see that the appropriate configuration rules have been deconfigured. In the Grafana Dashboard, given that there is no service configured, you should see a 0-valued flat plot again.


**Cleanup**

This last step performs a cleanup of the scenario removing all the TeraFlowSDN entities for completeness.
To run this step, execute the script:

```
./src/tests/ofc22/run_test_04_cleanup.sh
```

When the script finishes, check the WebUI *Devices* tab, you should see that the devices have been removed. Besides, in the *Services* tab you can see that the "admin" Context has no services given that that context has been removed.

## **3.2. ECOC'22 Demo**

This functional test reproduces the experimental assessment of *Experimental Demonstration of Transport Network Slicing with SLA Using the TeraFlowSDN Controller*  presented at [ECOC'22](https://www.optica.org/en-us/events/topical_meetings/ecoc/schedule/?day=Tuesday#Tuesday) / [IEEEXplore](https://ieeexplore.ieee.org/abstract/document/9979396).

The main features demonstrated are:

- Disjoint DC-2-DC L2VPN Service management
- Integration with ETSI OpenSourceMANO

<h3><u>Functional test folder</h3></u>

This functional test can be found in folder `./src/tests/ecoc22/`.

<h3><u>Execute with real devices</h3></u>

This functional test has only been tested with emulated devices; however, if you have access to real devices, you can modify the files `./src/tests/ecoc22/tests/Objects.py` and `./src/tests/ecoc22/tests/Credentials.py` to point to your devices, and map to your network topology. Otherwise, you can modify the `./src/tests/ecoc22/tests/descriptors_emulated.json` that is designed to be uploaded through the WebUI instead of using the command line scripts.

__Important__: The device drivers operating with real devices, e.g., OpenConfigDriver, 
               P4Driver, and TransportApiDriver, have to be considered as experimental. 
               The configuration and monitoring capabilities they support are
               limited or partially implemented/tested. Use them with care.


<h3><u>Deployment and Dependencies</h3></u>

To run this functional test, it is assumed you have deployed a MicroK8s-based Kubernetes environment and a TeraFlowSDN controller instance as described in the [Tutorial: Deployment Guide](https://tfs.etsi.org/documentation/develop/deployment_guide/), and you configured the Python environment as described in [Tutorial: Development Guide > Configure Environment > Python](https://tfs.etsi.org/documentation/develop/development_guide/#211-python).

<h3><u>Access to the WebUI</h3></u>

When the deployment completes, you can connect to the TeraFlowSDN WebUI as described in [Tutorial: Deployment Guide > WebUI and Grafana Dashboards](https://tfs.etsi.org/documentation/develop/deployment_guide/#14-webui-and-grafana-dashboards)

Notes:

- this experiment does not make use of Monitoring, so Grafana is not used.
- the default credentials for the Grafana Dashboard is user/pass: `admin`/`admin123+`.
- this functional test does not involve the Monitoring component, so no monitoring
  data is plotted in Grafana.

<h3><u>Test execution</h3></u>

Before executing the tests, we need to prepare a few things.

First, you need to make sure that you have all the gRPC-generate code in your folder. To do so, run:

```
proto/generate_code_python.sh
```

Second, it is time to deploy TeraFlowSDN with the correct specification for this scenario. Make sure to load your deployment variables for this scenario by:

```
source src/tests/ecoc22/deploy_specs.sh
```

Then, you need to deploy the components by running:

```
./deploy/all.sh
```

After the deployment is finished, you need to load the environment variables to support the execution of the tests by:

```
source tfs_runtime_env_vars.sh
```

To execute this functional test, four main steps needs to be carried out:

1. Device bootstrapping
2. L2VPN Slice and Services creation
3. L2VPN Slice and Services removal
4. Cleanup

Upon the execution of each test progresses, a report will be generated indicating 
*PASSED* / *FAILED* / *SKIPPED*.  If there is some error during the execution, you should see a detailed report on the error. See the troubleshooting section if needed.

You can check the logs of the different components using the appropriate
`scripts/show_logs_[component].sh` scripts after you execute each step.

**Device bootstrapping**

This step configures some basic entities (Context and Topology), the devices, and the links in the topology. 
The expected results are:

- The devices to be added into the Topology.
- The devices to be pre-configured and initialized as *ENABLED* by the Automation component.
- The links to be added to the topology.

To run this step, you can do it from the WebUI by uploading the file `./src/tests/ecoc22/tests/descriptors_emulated.json` that contains the descriptors of the contexts, topologies, devices, and links, or by executing the `./src/tests/ecoc22/run_test_01_bootstrap.sh` script.

In the WebUI, select the *admin* Context. Then, in the *Devices* tab you should see that 5 different emulated devices have been 
created and activated: 4 packet routers, and 1 optical Open Line System (OLS) controller. Besides, in the *Services* tab you should see that there is no service created. 

**L2VPN Slice and Services creation**

This step configures a new service emulating the request an OSM WIM would make by means of a Mock OSM instance.

To run this step, execute the `./src/tests/ecoc22/run_test_02_create_service.sh` script.

When the script finishes, check the WebUI *Slices* and *Services* tab. You should see that, for the connectivity service requested by MockOSM, one slice has been created, three services have been created (two for the optical layer and another for the packet layer). Note that the two services for the optical layer correspond to the primary (service_uuid ending with ":0") and the backup (service_uuid ending with ":1") services. Each of the services indicates the connections and sub-services that are supporting them. Besides, you can check the *Devices* tab to see the configuration rules that have been 
configured in each device.

**L2VPN Slice and Services removal**

This step deconfigures the previously created slices and services emulating the request an OSM WIM would make by means of a Mock OSM instance.

To run this step, execute the `./src/tests/ecoc22/run_test_03_delete_service.sh` script, or delete the slice from the WebUI.

When the script finishes, check the WebUI *Slices* and *Services* tab. You should see that the slice and the services have been removed.
Besides, in the *Devices* tab you can see that the appropriate configuration rules have been deconfigured.

**Cleanup**

This last step performs a cleanup of the scenario removing all the TeraFlowSDN entities for completeness.

To run this step, execute the `./src/tests/ecoc22/run_test_04_cleanup.sh` script.

When the script finishes, check the WebUI *Devices* tab, you should see that the devices have been removed. Besides, in the *Slices* and *Services* tab you can see that the *admin* Context has no services given that that context has been removed.

## **3.3. OECC-PSC'22 Demo (Work In Progress)**

**Page under construction.**

The main features demonstrated are:

- Interdomain Slices


## **3.4. NFV-SDN'22 Demo (Work In Progress)**

**Page under construction.**

The main features demonstrated are:

- DLT-based context sharing
- DLT-based Interdomain Slices with SLAs


