
This page describes how to configure a VM for running ETSI TeraFlowSDN(TFS) controller using [OpenStack](https://www.openstack.org/). It has been tested with OpenStack Kolla up to Yoga version. 

# Create a Security Group in OpenStack
In OpenStack, go to Project - Network - Security Groups - Create Security Group with name TFS

Add the following rules:

|Direction  |Ether Type |IP Protocol |Port Range | Remote IP Prefix|
|-----------|-----------|------------|-----------|-----------------|
|Ingress	|IPv4	|TCP	|22 (SSH)	|0.0.0.0/0|
|Ingress	|IPv4	|TCP	|2200	|0.0.0.0/0|	
|Ingress	|IPv4	|TCP	|8080	|0.0.0.0/0|	
|Ingress	|IPv4	|TCP	|80	|0.0.0.0/0|
|Egress	|IPv4	|Any	|Any	|0.0.0.0/0|	
|Egress	|IPv6	|Any	|Any	|::/0|

__Note__: The IP address will be assigned depending on the network you have configured inside OpenStack. This IP will have to be modified in TeraFlow configuration files which by default use IP 10.0.2.10

# Create a flavour

## From dashboard (Horizon)

Go to Admin - Compute - Flavors and press Create Flavor

- Name: TFS
- VCPUs: 4
- RAM (MB): 8192
- Root Disk (GB): 60

## From CLI
```
 openstack flavor create TFS --id auto --ram 8192 --disk 60 --vcpus 8
```
# Create an instance in OpenStack:

- Instance name: TFS-VM
- Origin: [Ubuntu-22.04 cloud image] (https://cloud-images.ubuntu.com/jammy/current/jammy-server-cloudimg-amd64.img)
- Create new volume: No
- Flavor: TFS
- Networks: extnet 
- Security Groups: TFS
- Configuration: Include the following cloud-config

```
#cloud-config
# Modifies the password for the VM instance
username: ubuntu
password: <your-password>
chpasswd: { expire: False }
ssh_pwauth: True
```


## Upgrade the Ubuntu distribution
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```
- If asked to restart services, restart the default ones proposed.
- Restart the VM when the installation is completed.

