# Common Operations

## Register an Invoker

### Steps to perform operation
  1. Create public and private key at invoker
  2. Register of Invoker at CCF:
     * Send POST to http://{CAPIF_HOSTNAME}:{CAPIF_HTTP_PORT}/register
     * Body [invoker register body]

  3. Obtain Access Token:
     * Send POST to *http://{CAPIF_HOSTNAME}/getauth*
     * Body [invoker getauth body]

  4.  Onboard Invoker:     
         * Send POST to https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers
         * Reference Request Body: [invoker onboarding body]
         * "onboardingInformation"->"apiInvokerPublicKey": must contain public key generated by Invoker.
         * Send at Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})

### Checks to ensure onboarding
   1. Response to Register:
      1. **201 Created**

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Response to Onboard request must accomplish:
      1. **201 Created**
      2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
         * apiInvokerId
         * onboardingInformation->apiInvokerCertificate must contain the public key signed.
      3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*


## Register a Provider

### Steps to Perform operation
  1. Create public and private key at provider for provider itself and each function (apf, aef and amf)
  2. Register of Provider at CCF:
     * Send POST to *http://{CAPIF_HOSTNAME}:{CAPIF_HTTP_PORT}/register*
     * body [provider register body]

  3. Obtain Access Token:
     * Send POST to *http://{CAPIF_HOSTNAME}/getauth*
     * Body [provider getauth body]

  4. Register Provider:
     * Send POST *https://{CAPIF_HOSTNAME}/api-provider-management/v1/registrations*
     * body [provider request body]
     * Send at Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})
     * Store each cert in a file with according name.

### Checks to ensure provider registration
   1. Response to Register:
      1. **201 Created**

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Register Provider at Provider Management:
      1. **201 Created** response.
      2. body returned must accomplish **APIProviderEnrolmentDetails** data structure.
      3. For each **apiProvFuncs**, we must check:
         1. **apiProvFuncId** is set
         2. **apiProvCert** under **regInfo** is set properly
      4. Location Header must contain the new resource URL *{apiRoot}/api-provider-management/v1/registrations/{registrationId}*





[invoker register body]: ../api_invoker_management/invoker_register_body.json  "Invoker Register Body"
[invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
[invoker getauth body]: ../api_invoker_management/invoker_getauth_example.json    "Get Auth Example"

[provider register body]: ../api_provider_management/provider_register_body.json  "Provider Register Body"
[provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
[provider getauth body]: ../api_provider_management/provider_getauth_example.json    "Get Auth Example"





[Return To All Test Plans]: ../README.md
