This page describes how to configure a VM for running ETSI TeraFlowSDN(TFS) controller using [VMWare Fusion](https://www.vmware.com/products/fusion.html). It has been tested with VMWare Fusion version 12 and 13.

# Create VM in VMWare Fusion:

In "VMWare Fusion" manager, create a new network from the "Settings/Network" menu.

- Unlock to make changes
- Press the + icon and create a new network
- Change the name to TFS-NAT-Net
- Check "Allow virtual machines on this network to connect to external network (NAT)"
- Do not check "Enable IPv6"
- Add port forwarding for HTTP and SSH
- Uncheck "Provide address on this network via DHCP"

Create a new VM an Ubuntu 22.04.1 ISO:

- Display Name: TeraFlowSDN
- Username: tfs
- Password: tfs123

On the next screen press "Customize Settings", save the VM and in "Settings" change:
- Change to use 4 CPUs
- Change to access 8 GB of RAM
- Change disk to size 60 GB
- Change the network interface to use the previously created TFS-NAT-Net

Run the VM to start the installation.

# Install Ubuntu 22.04.1 LTS Operating System

The installation will be automatic, without any configuration required.

- Configure the guest IP, gateway and DNS:

  Using the Network Settings for the wired connection, set the IP to 10.0.2.10,
  the mask to 255.255.255.0, the gateway to 10.0.2.2 and the DNS to 10.0.2.2.

- Disable and remove swap file:

  $ sudo swapoff -a
  $ sudo rm /swapfile

  Then you can remove or comment the /swapfile entry in /etc/fstab

- Install Open SSH Server
  - Import SSH keys, if any.

- Restart the VM when the installation is completed.

# Upgrade the Ubuntu distribution
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```
