This section summarizes the NBI connectors supported by the TeraFlowSDN controller to interoperate with OSS/BSS/NFVO on top of it.

    - [6.1. TFS API](#61-tfs-apie)
    - [6.2. ETSI Bandwidth Management (BWM)](#62-etsi-bandwidth-management-bwm)
    - [6.3. IETF L2VPN Service Delivery (L2SM) [RFC8466]](#63-ietf-l2vpn-service-delivery-l2sm-rfc8466)
    - [6.4. IETF L3VPN Service Delivery (L3SM) [RFC8299]](#64-ietf-l3vpn-service-delivery-l3sm-rfc8299)
    - [6.5. IETF Network Topology [RFC8345]](#65-ietf-network-topology-rfc8345)
    - [6.6. IETF Network Slice Service [draft-ietf-teas-ietf-network-slice-nbi-yang]](#66-ietf-network-slice-service-draft-ietf-teas-ietf-network-slice-nbi-yang)

## **6.1. TFS APIe**

This NBI connector exposes the basic gRPC methods of TeraFlowSDN that enable to manage contexts, topologies, devices, links, services, slices, connections, and policies.

<h3><u>Exposed endpoints:</h3></u>

**Endpoint `/tfs-api/context_ids`**
- Method: `GET`
  - Used to list the context identifiers

**Endpoint `/tfs-api/contexts`**
- Method: `GET`
  - Used to list the details of all contexts

**Endpoint `/tfs-api/dummy_contexts`**
- Method: `GET`
  - Used to dump contexts (including related topologies, devices, links, services, slices, and connections) in a snapshot format that can be imported directly in TeraFlowSDN WebUI.
  - IMPORTANT: the resulting document is processed by WebUI in dummy mode, i.e., just to populate Context database, but not interacting with Device, Service, and Slice components.

**Endpoint `/tfs-api/context/<path:context_uuid>`**
- Method: `GET`
  - Used to retrieve a specific context

**Endpoint `/tfs-api/context/<path:context_uuid>/topology_ids`**
- Method: `GET`
  - Used to list the topology identifiers in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/topologies`**
- Method: `GET`
  - Used to list all the topology details in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/topology/<path:topology_uuid>`**
- Method: `GET`
  - Used to retrieve a specific topology in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/service_ids`**
- Method: `GET`
  - Used to list the service identifiers in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/services`**
- Method: `GET`
  - Used to list all the service details in a context

- Method: `POST`
  - Used to create a service

- Method: `PUT`
  - Used to update a service

- Method: `DELETE`
  - Used to delete a service

**Endpoint `/tfs-api/context/<path:context_uuid>/service/<path:service_uuid>`**
- Method: `GET`
  - Used to retrieve a specific service in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/slice_ids`**
- Method: `GET`
  - Used to list the slice identifiers in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/slices`**
- Method: `GET`
  - Used to list all the slice details in a context

**Endpoint `/tfs-api/context/<path:context_uuid>/slice/<path:slice_uuid>`**
- Method: `GET`
  - Used to retrieve a specific slice in a context

**Endpoint `/tfs-api/device_ids`**
- Method: `GET`
  - Used to list the device identifiers

**Endpoint `/tfs-api/devices`**
- Method: `GET`
  - Used to list the device details

**Endpoint `/tfs-api/device/<path:device_uuid>`**
- Method: `GET`
  - Used to retrieve a specific device

**Endpoint `/tfs-api/link_ids`**
- Method: `GET`
  - Used to list the link identifiers

**Endpoint `/tfs-api/links`**
- Method: `GET`
  - Used to list the link details

**Endpoint `/tfs-api/link/<path:link_uuid>`**
- Method: `GET`
  - Used to retrieve a specific link

**Endpoint `/tfs-api/context/<path:context_uuid>/service/<path:service_uuid>/connection_ids`**
- Method: `GET`
  - Used to list the connection identifiers related to a service

**Endpoint `/tfs-api/context/<path:context_uuid>/service/<path:service_uuid>/connections`**
- Method: `GET`
  - Used to list all the connection details related to a service

**Endpoint `/tfs-api/connection/<path:connection_uuid>`**
- Method: `GET`
  - Used to retrieve a specific connection

**Endpoint `/tfs-api/policyrule_ids`**
- Method: `GET`
  - Used to list all the policy rule identifiers

**Endpoint `/tfs-api/policyrules`**
- Method: `GET`
  - Used to list all the policy rule details

**Endpoint `/tfs-api/policyrule/<path:policyrule_uuid>`**
- Method: `GET`
  - Used to retrieve a specific policy rule


## **6.2. ETSI Bandwidth Management (BWM)**

ETSI Traffic Bandwidth Management (BWM) API (GS MEC 015)

__Documentation in progress__

<h3><u>Supported features:</h3></u>
- L3 connectivity service management

<h3><u>Tested OSS/BSS/NFVO:</h3></u>
- Proprietary Moonlight extension
- Standalone script

<h3><u>Reference:</h3></u>
- ETSI Traffic Bandwidth Management (BWM) API (GS MEC 015)


## **6.3. IETF L2VPN Service Delivery (L2SM) [RFC8466]**

IETF RFC8466: A YANG Data Model for Layer 2 Virtual Private Network (L2VPN) Service Delivery

__Documentation in progress__

<h3><u>Supported features:</h3></u>
- L2 VPN management

<h3><u>Tested OSS/BSS/NFVO:</h3></u>
- ETSI OpenSource MANO v12.1+

<h3><u>Reference:</h3></u>
- [IETF RFC8466: A YANG Data Model for Layer 2 Virtual Private Network (L2VPN) Service Delivery](https://datatracker.ietf.org/doc/html/rfc8466)

## **6.4. IETF L3VPN Service Delivery (L3SM) [RFC8299]**

IETF RFC8299: YANG Data Model for L3VPN Service Delivery

__Documentation in progress__

<h3><u>Supported features:</h3></u>
- L3 VPN management

<h3><u>Tested OSS/BSS/NFVO:</h3></u>
- Proprietary OSM extensions
- Standalone script

<h3><u>Reference:</h3></u>
- [IETF RFC8299: YANG Data Model for L3VPN Service Delivery](https://datatracker.ietf.org/doc/html/rfc8299)


## **6.5. IETF Network Topology [RFC8345]**

IETF RFC8345: A YANG Data Model for Network Topologies

__Documentation in progress__

This extension also features partial support for:
- IETF RFC 8795: YANG Data Model for Traffic Engineering (TE) Topologies
- IETF RFC draft-ietf-ccamp-eth-client-te-topo-yang-05: A YANG Data Model for Ethernet TE Topology
- IETF RFC draft-ietf-ccamp-client-signal-yang-10: A YANG Data Model for Transport Network Client Signals

<h3><u>Supported features:</h3></u>
- Static topology exposition

<h3><u>Tested OSS/BSS/NFVO:</h3></u>
- Proprietary OSM extensions
- Standalone script

<h3><u>Reference:</h3></u>

- [IETF RFC8345: A YANG Data Model for Network Topologies](https://datatracker.ietf.org/doc/html/rfc8345)
- [IETF RFC8795: YANG Data Model for Traffic Engineering (TE) Topologies](https://datatracker.ietf.org/doc/html/rfc8795)
- [IETF RFC8776: Common YANG Data Types for Traffic Engineering](https://datatracker.ietf.org/doc/html/rfc8776)
- [IETF RFC6991: Common YANG Data Types](https://datatracker.ietf.org/doc/html/rfc6991)
- [IETF draft-ietf-ccamp-eth-client-te-topo-yang-05: A YANG Data Model for Ethernet TE Topology](https://datatracker.ietf.org/doc/draft-ietf-ccamp-eth-client-te-topo-yang/)
- [IETF draft-ietf-ccamp-client-signal-yang-10: A YANG Data Model for Transport Network Client Signals](https://datatracker.ietf.org/doc/draft-ietf-ccamp-client-signal-yang/)

## **6.6. IETF Network Slice Service [draft-ietf-teas-ietf-network-slice-nbi-yang]**

IETF draft-ietf-teas-ietf-network-slice-nbi-yang: A YANG Data Model for the RFC 9543 Network Slice Service

Important: implemented version is based on version 2 of the draft:
- draft-ietf-teas-ietf-network-slice-nbi-yang-02: IETF Network Slice Service YANG Model

__Documentation in progress__

<h3><u>Supported features:</h3></u>
- L2/L3 slice management

<h3><u>Tested OSS/BSS/NFVO:</h3></u>
- Standalone script

<h3><u>Reference:</h3></u>

- [IETF draft-ietf-teas-ietf-network-slice-nbi-yang-02: IETF Network Slice Service YANG Model](https://datatracker.ietf.org/doc/draft-ietf-teas-ietf-network-slice-nbi-yang/02/)

