This section summarizes the SBI drivers supported by the TeraFlowSDN controller to interoperate with underlying network equipment and intermediate controllers.

- [5.1. Emulated](#51-emulated)
- [5.2. NetConf OpenConfig](#52-netconf-openconfig)
- [5.3. gNMI OpenConfig](#53-gnmi-openconfig)
- [5.4. ONF Transport API](#54-onf-transport-api)
- [5.5. P4](#55-p4)
- [5.6. Infinera IPM XR](#56-infinera-ipm-xr)
- [5.7. IETF L2VPN](#57-ietf-l2vpn)
- [5.8. IETF ACTN](#58-ietf-actn)
- [5.9. NetConf OpenConfig Optical](#59-netconf-openconfig-optical)
- [5.10. Optical TFS](#510-optical-tfs)
- [5.11. MicroWave](#511-microwave)

## **5.1. Emulated**

__Documentation in progress__

This driver is provided for testing and debugging purposes.
It implements an accept-anything behaviour and maintains an in-memory database with configured rules.
It implements support for synthetic telemetry streaming data that is activated/deactivated according to enabled/disabled device endpoints.

<h3><u>Device Type:</h3></u>

- Software Emulated within TeraFlowSDN's Device component.

<h3><u>Supported features:</h3></u>

- Configuration
- Monitoring (synthetic)

<h3><u>Tested Devices/Controllers:</h3></u>
Not applicable.

<h3><u>Reference:</h3></u>
None

## **5.2. NetConf OpenConfig**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Packet Router

<h3><u>Supported features:</h3></u>

- Configuration of interfaces, L2/L3 VPNs, ACLs
- Monitoring of interfaces through polling

<h3><u>Tested Devices/Controllers:</h3></u>

- Infinera DRX-30 with ADVA NOS-OPX-B-21.5.1
- Edgecore AS7315-30X with ADVA NOS-OPX-B-21.5.1

<h3><u>Reference:</h3></u>

- [IETF RFC6241: Network Configuration Protocol (NETCONF)](https://datatracker.ietf.org/doc/html/rfc6241)
- [OpenConfig](https://www.openconfig.net/)
- [OpenConfig GitHub](https://github.com/openconfig/public)

## **5.3. gNMI OpenConfig**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Packet Router

<h3><u>Supported features:</h3></u>

- Configuration of interfaces and IPv4 network instances with static routes
- Monitoring of interfaces through telemetry streaming

<h3><u>Tested Devices/Controllers:</h3></u>

- Nokia SR Linux v23.3.1

<h3><u>Reference:</h3></u>

- [OpenConfig](https://www.openconfig.net/)
- [OpenConfig GitHub](https://github.com/openconfig/public)
- [OpenConfig gNMI](https://www.openconfig.net/docs/gnmi/gnmi-specification/)
- [OpenConfig gNMI GitHub](https://github.com/openconfig/gnmi)

## **5.4. ONF Transport API**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- Configuration of L0 optical links
- Monitoring is not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- CTTC Open Line System controller

<h3><u>Reference:</h3></u>

- [ONF Transport API](https://wiki.opennetworking.org/display/OTCC/TAPI)
- [ONF Transport API GitHub](https://github.com/OpenNetworkingFoundation/TAPI)


## **5.5. P4**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- Configuration of L2 packet connections
- Monitoring not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- BMV2
- Intel Tofino P4 switch

<h3><u>Reference:</h3></u>

## **5.6. Infinera IPM XR**

Infinera XR Pluggables through Infinera IPM controller

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- Configuration of L0 optical links
- Monitoring not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- Infinera Pluggable Manager (IPM) controller

<h3><u>Reference:</h3></u>

## **5.7. IETF L2VPN**

IETF RFC8466: A YANG Data Model for Layer 2 Virtual Private Network (L2VPN) Service Delivery

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- Discovery of underlyting topology
- Configuration of L2 VPNs
- Monitoring not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- TeraFlowSDN as child IP controller

<h3><u>Reference:</h3></u>

- [IETF RFC8466: A YANG Data Model for Layer 2 Virtual Private Network (L2VPN) Service Delivery](https://datatracker.ietf.org/doc/html/rfc8466)

## **5.8. IETF ACTN**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- Configure OSU Tunnels
- Configure Ethernet Transport Services

<h3><u>Tested Devices/Controllers:</h3></u>

- Huawei NCE-T SDN controller

<h3><u>Reference:</h3></u>

- [IETF draft-ietf-ccamp-client-signal-yang-10: A YANG Data Model for Transport Network Client Signals](https://datatracker.ietf.org/doc/draft-ietf-ccamp-client-signal-yang/)
- [IETF draft-ietf-teas-yang-te-34: A YANG Data Model for Traffic Engineering Tunnels, Label Switched Paths and Interfaces](https://datatracker.ietf.org/doc/draft-ietf-teas-yang-te/)

## **5.9. NetConf OpenConfig Optical**

NetConf - OpenConfig for Optical Devices (EXPERIMENTAL)

**WARNING**: This driver is experimental and contains proprietary extensions on top of OpenConfig. Use with care.

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Optical Transponders
- Multi-granular Optical Nodes

<h3><u>Supported features:</h3></u>

- Configure L0 optical connections
- Monitoring not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- Proprietary NetConf/OpenConfig agents

<h3><u>Reference:</h3></u>

- [IETF RFC6241: Network Configuration Protocol (NETCONF)](https://datatracker.ietf.org/doc/html/rfc6241)
- [OpenConfig](https://www.openconfig.net/)
- [OpenConfig GitHub](https://github.com/openconfig/public)

## **5.10. Optical TFS**

__Documentation in progress__

<h3><u>Device Type:</h3></u>

- Intermediate Controller

<h3><u>Supported features:</h3></u>

- L0 optical connections
- Monitoring is not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- TeraFlowSDN as child optical controller

<h3><u>Reference:</h3></u>

## **5.11. MicroWave**

__Documentation in progress__

This driver manages microwave radio links through an intermediate controller using the data model in IETF RFC8345 "A YANG Data Model for Network Topologies".

<h3><u>Device Type:</h3></u>

- Radio links between routers through an Intermediate Controller

<h3><u>Supported features:</h3></u>

- L2 radio links
- Monitoring not supported

<h3><u>Tested Devices/Controllers:</h3></u>

- SIAE intermediate MW controller version SM-DC 8.3.2 managing SIAE AGS20 radio terminals

<h3><u>Reference:</h3></u>

- [IETF RFC8345: A YANG Data Model for Network Topologies](https://datatracker.ietf.org/doc/html/rfc8345)

