This section walks you through the process of deploying TeraFlowSDN on top of a machine running [MicroK8s Kubernetes platform](https://microk8s.io).
The guide includes the details on configuring and installing the machine, installing and 
configuring MicroK8s, and deploying and reporting the status of the TeraFlowSDN 
controller.

# 1.1. Configure your Machine

In this section, we describe how to configure a machine (physical or virtual) to be used as the deployment, execution, and development environment for the ETSI TeraFlowSDN controller. Choose your preferred environment below and follow the instructions provided.

**NOTE**: If you already have a remote physical server fitting the requirements specified in this section feel free to use it instead of deploying a local VM. Check [1.1.1. Physical Server](#1-1-1-physical-server) for further details.

Virtualization platforms tested are:
- [Physical Server](#1-1-1-physical-server)
- [Oracle Virtual Box](#1-1-2-oracle-virtual-box)
- [VMWare Fusion](#1-1-3-vmware-fusion)
- ['1.1.4. OpenStack'](#1-1-4-openstack)
- [1.1.5. Vagrant Box](#1-1-5-vagrant-box)

## 1.1.1. Physical Server
This page describes how to configure a physical server for running ETSI TeraFlowSDN(TFS) controller.

### Server Specifications

#### Minimum Server Specifications for development and basic deployment
- CPU: 4 cores
- RAM: 8 GB
- Disk: 60 GB
- 1 GbE NIC

#### Recommended Server Specifications for development and basic deployment
- CPU: 6 cores
- RAM: 12 GB
- Disk: 80 GB
- 1 GbE NIC

#### Server Specifications for best development and deployment experience
- CPU: 8 cores
- RAM: 32 GB
- Disk: 120 GB
- 1 GbE NIC

**NOTE**: the specifications listed above are provided as a reference. They depend also on the CPU clock frequency, the RAM memory, the disk technology and speed, etc.

For development purposes, it is recommended to run the VSCode IDE (or the IDE of your choice) in a more powerful server, for instance, the recommended server specifications for development and basic deployment.

Given that TeraFlowSDN follows a micro-services architecture, for the deployment, it might be better to use many clusterized servers with many slower cores than a single server with few highly performant cores.


### Clusterized Deployment
You might consider creating a cluster of machines each featuring, at least, the minimum server specifications. That solution brings you scalability in the future.


### Networking
No explicit indications are given in terms of networking besides that servers need access to the Internet for downloading dependencies, binaries, and packages while building and deploying the TeraFlowSDN components.

Besides that, the network requirements are essentially the same than that required for running a classical Kubernetes environment. To facilitate the deployment, we extensively use [MicroK8s](https://microk8s.io/), thus the network requirements are, essentially, the same demanded by MicroK8s, especially, if you consider creating a Kubernetes cluster.

As a reference, the other deployment solutions based on VMs assume the VM is connected to a virtual network configured with the IP range `10.0.2.0/24` and have the gateway at IP `10.0.2.1`. The VMs have the IP address `10.0.2.10`.

The minimum required ports to be accessible are:
- 22/SSH     : for management purposes
- 80/HTTP    : for the TeraFlowSDN WebUI and Grafana dashboard
- 8081/HTTPS : for the CockroachDB WebUI

Other ports might be required if you consider to deploy addons such as Kubernetes observability, etc. The details on these ports are left appart given they might vary depending on the Kubernetes environment you use.


### Operating System

The recommended Operating System for deploying TeraFlowSDN is [Ubuntu Server 22.04 LTS](https://releases.ubuntu.com/jammy/) or [Ubuntu Server 20.04 LTS](https://releases.ubuntu.com/focal/). Other version might work, but we have not tested them. We strongly recommend using Long Term Support (LTS) versions as they provide better stability.

Below we provide some installation guidelines:
- Installation Language: English
- Autodetect your keyboard
- If asked, select "Ubuntu Server" (do not select "Ubuntu Server (minimized)").
- Configure static network specifications (adapt them based on your particular setup):

|Interface|IPv4 Method|Subnet     |Address  |Gateway |Name servers   |Search domains|
|---------|-----------|-----------|---------|--------|---------------|--------------|
|enp0s3   |Manual     |10.0.2.0/24|10.0.2.10|10.0.2.1|8.8.8.8,8.8.4.4|<empty>       |

- Leave proxy and mirror addresses as they are
- Let the installer self-upgrade (if asked).
- Use an entire disk for the installation
  - Disable setup of the disk as LVM group
  - Double check that NO swap space is allocated in the partition table. Kubernetes does not work properly with SWAP.
- Configure your user and system names:
  - User name: `TeraFlowSDN`
  - Server's name: `tfs-vm`
  - Username: `tfs`
  - Password: `tfs123`
- Install Open SSH Server
  - Import SSH keys, if any.
- Featured Server Snaps
  - Do not install featured server snaps. It will be done manually later to illustrate how to uninstall and reinstall them in case of trouble with.
- Let the system install and upgrade the packages.
  - This operation might take some minutes depending on how old is the Optical Drive ISO image you use and your Internet connection speed.
- Restart the VM when the installation is completed.

### Upgrade the Ubuntu distribution
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```
- If asked to restart services, restart the default ones proposed.
- Restart the VM when the installation is completed.

## 1.1.2. Oracle Virtual Box

## 1.1.3. VMWare Fusion

## 1.1.4. OpenStack

## 1.1.5. Vagrant Box

Other virtualization environments might be used; in that case, you will need to adapt these instructions to your particular case. If you want to contribute with details on how you used other hypervisors or platforms, [contact](https://labs.etsi.org/rep/tfs/controller/-/wikis/home#contact) the TFS team through Slack.

# 1.2. Install MicroK8s
# 1.3. Deploy TeraFlowSDN
# 1.4. WebUI and Grafana Dashboards
# 1.5. Show Deployment and Logs
