<img src="images/logos/TeraFlowSDN_tr.png" alt="drawing" width="200"/>

Welcome to the ETSI TeraFlowSDN (TFS) Controller wiki!

This wiki provides a walkthrough on how to prepare your environment for executing and contributing to the ETSI SDG TeraFlowSDN.
Besides, it describes how to run some example experiments.

# Try TeraFlowSDN Release 3.0
The new release launched on April 24th, 2024 incorporates a number of new features, improvements, and bug resolutions. Try it by following the guides below, and feel free to give us your feedback.
See the [Release Notes](https://labs.etsi.org/rep/tfs/controller/-/releases/v3.0.0).

# Requisites
The guides and walkthroughs below make some reasonable assumptions to simplify the deployment of the TFS controller, the execution of experiments and tests, and the development of new contributions.
In particular, we assume:

  - A physical server or virtual machine for running the TFS controller with the following minimum specifications (check section [Configure your Machine](https://tfs.etsi.org/documentation/develop/deployment_guide/#11-configure-your-machine) for additional details):
    * 4 cores / vCPUs
    * 8 GB of RAM (10 GB of RAM if you want to develop)
    * 60 GB of disk (100 GB of disk if you want to develop)
    * 1 NIC card
  - [VSCode](https://code.visualstudio.com/) with the [Remote SSH](https://code.visualstudio.com/docs/remote/ssh) extension
  - Working machine software:
    - [Ubuntu Server 22.04.4 LTS](https://releases.ubuntu.com/22.04/) or [Ubuntu Server 20.04.6 LTS](https://releases.ubuntu.com/20.04/)
    - [MicroK8s v1.24.17](https://microk8s.io/)

Use the Wiki menu in the right side of this page to navigate through the various contents of this wiki.

# Guides and Walkthroughs
The following guides and walkthroughs are provided:

- [1. Deployment Guide](https://tfs.etsi.org/documentation/develop/deployment_guide/)
- [2. Development Guide](https://tfs.etsi.org/documentation/develop/development_guide/)
- [3. Run Experiments](https://tfs.etsi.org/documentation/develop/run_experiments/)
- [4. Features and Bugs](https://tfs.etsi.org/documentation/develop/features_and_bugs/)
- [5. Supported SBIs and Network Elements](https://tfs.etsi.org/documentation/develop/supported_sbis_and_network_elements/)
- [6. Supported NBIs](https://tfs.etsi.org/documentation/develop/supported_nbis/)
- [7. Supported Service Handlers](https://tfs.etsi.org/documentation/develop/supported_service_handlers/)
- [8. Troubleshooting](https://tfs.etsi.org/documentation/develop/troubleshooting/)


# Tutorials and TFS Virtual Machine
This section provides access to the links and all the materials prepared for the tutorials and hackfests involving ETSI TeraFlowSDN.

- [TFS Hackfest #3 (Castelldefels, 16-17 October 2023)](https://labs.etsi.org/rep/groups/tfs/-/wikis/TFS-HACKFEST-3)
  - The link includes explanatory material on P4 for TeraFlowSDN, the set of guided walkthrough, and the details on the interactive sessions the participants addressed (and recordings), as well as a TFS Virtual Machine (Release 2.1).

- [TFS Hackfest #2 (Madrid, 20-21 June 2023)](https://labs.etsi.org/rep/groups/tfs/-/wikis/TFS-HACKFEST-2)
  - The link includes explanatory material on gNMI and ContainerLab for TeraFlowSDN, the set of challenges the participants addressed (and recordings), as well as a TFS Virtual Machine (Pre-Release 2.1).

- [OFC SC472 (San Diego, 6 March 2023)](https://labs.etsi.org/rep/groups/tfs/-/wikis/OFC-SC472-2023)
  - The link includes a tutorial-style slide deck, as well as a TFS Virtual Machine (Release 2).

- [TFS Hackfest #1 (Amsterdam, 20 October 2022)](https://labs.etsi.org/rep/groups/tfs/-/wikis/TFS-HACKFEST-1)
  - The link includes a tutorial-style slide deck (and recordings), as well as a TFS Virtual Machine (Pre-Release 2).
  
# Versions

New versions of TeraFlowSDN are periodically released.
Each release is properly tagged and a branch is kept for its future bug fixing, if needed.

- The branch *master*, points always to the latest stable version of the TeraFlowSDN controller.
- The branches *release/X.Y.Z*, point to the code for the different release versions indicated in branch name.
  - Code in these branches can be considered stable, and no new features are planned.
  - In case of bugs, point releases increasing revision number (Z) might be created.
- The main development branch is named as *develop*.
  - **Use with care! Might not be stable.**
  - The latest developments and contributions are added to this branch for testing and validation before reaching a release. 

To choose the appropriate branch, follow the steps described in [1.3. Deploy TeraFlowSDN > Checkout the Appropriate Git Branch](https://tfs.etsi.org/documentation/develop/deployment_guide/#13-deploy-teraflowsdn)

# Events
Find here after the list of past and future TFS Events:

- [ETSI TeraFlowSDN Events](https://labs.etsi.org/rep/groups/tfs/-/wikis/TFS-Events) 

# Contact
If your environment does not fit with the proposed assumptions and you experience issues 
preparing it to work with the ETSI TeraFlowSDN controller, contact the ETSI TeraFlowSDN 
SDG team through
[Slack](https://join.slack.com/t/teraflowsdn/shared_invite/zt-18gc5jvkh-1_DEZHFhxeuOqzJZPq~U~A)

