# Postman
In this section we can use Postman to publish an API as a provider and use it as an invoker.

## Requisites

- We will need to have Node.js installed since we will use a small script to create the CSRs of the certificates.
- An instance of CAPIF (If it is not local, certain variables would have to be modified both in the Node.js script and in the Postman environment variables).

## First steps

1. Install the Node dependencies <a href="./package.json" download>package.json</a> to run the script with:

```
npm i
```

1. Run the <a href="./script.js" download>script.js</a> with the following command:

```
node script.js
```

3. Import Postman collection and environment variables (<a href="./CAPIF.postman_collection.json" download>CAPIF.postman_collection.json</a> and <a href="./CAPIF.postman_environment.json" download>CAPIF.postman_environment.json</a>)
4. Select CAPIF Environment before start testing.

## Remote CAPIF

If the CAPIF is not local, the host and port of both the CAPIF and the register would have to be specified in the variables, and the CAPIF_HOSTNAME in the script, necessary to obtain the server certificate.

**Enviroments in Postman**
```
CAPIF_HOSTNAME     capifcore
CAPIF_PORT         8080
REGISTER_HOSTNAME  register
REGISTER_PORT      8084
```

**Const in script.js**
```
CAPIF_HOSTNAME    capifcore
```

## CAPIF Flows
Once the first steps have been taken, we can now use Postman requests. These requests are numbered in the order that must be followed to obtain everything necessary from CAPIF.

### Creation of an user

The first step would be for an administrator to create a user with which a provider and an invoker will be created.

#### **01-Login_admin**

![Flow](../../images/flows/01_Login_Admin.png)

#### **02-Register of User**

![Flow](../../images/flows/02_Register_of_User.png)

### Publication of an API

#### **03-getauth_provider**

![Flow](../../images/flows/03_Register_of_AEF_GetAuth.png)

#### **04-onboard_provider**

![Flow](../../images/flows/02_AEF_API_Provider_registration.png)

At this point we move on to using certificate authentication in CAPIF. In Postman it is necessary to add the certificates manually and using more than one certificate for the same host as we do in CAPIF complicates things. For this reason, we use the script to overwrite a certificate and a key when it is necessary to have a specific one.

To configure go to **settings** in Postman and open the **certificates** section. 

- Here, activate the **CA certificates** option and add the **ca_cert.pem** file found in the **Responses** folder.
- Adds a client certificate specifying the CAPIF host being used and the files **client_cert.crt** and **client_key.key** in the **Responses** folder.


Once this is done, the node script will be in charge of changing the certificate that is necessary in each request.

#### **05-publish_api**

![Flow](../../images/flows/05_AEF_Publish.png)

Once the api is published, we can start it. In this case we have a test one created in python called <a href="./hello_api.py" download>hello_api.py</a> that can be executed with the following command:

```
python3 hello_api.py
```

The API publication interface is set to localhost with port 8088, so the service must be set up locally. If you wanted to build it on another site, you would have to change the interface description in the body of publish_api.

With this the provider part would be finished.

### Calling the API

#### **06-getauth_invoker**

![Flow](../../images/flows/06_Invoker_Register_GetAuth.png)

#### **07-onboard_invoker**

![Flow](../../images/flows/07_Invoker_Onboarding.png)

At this point we move on to using certificate authentication in CAPIF. **If you did not configure the provider's certificates, you would have to do it now**.

#### **08-discover**

![Flow](../../images/flows/08_Invoker_Discover_AEF.png)

#### **09-security_context**

![Flow](../../images/flows/09_Invoker_Create_Security_Context.png)

#### **10-get_token**

![Flow](../../images/flows/10_Invoker_Get_Token.png)

#### **11-call_service**

![Flow](../../images/flows/11_Invoker_Send_Request_to_AEF_Service_API.png)

With this, we would have made the API call and finished the flow.

### Other requests

Other requests that we have added are the following:

- **offboard_provider**      Performs offboarding of the provider, thereby eliminating the published APIs.
- **offboard_invoker**       Offboards the invoker, also eliminating access to the APIs of that invoker.
- **remove_user_invoker**    Delete the user created for the invoker.
- **remove_user_provider**   Delete the user created for the provider.

## Notes

- This process is designed to teach how requests are made in Postman and the flow that should be followed to publish and use an API.
- It is possible that if external CAPIFs are used (Public CAPIF) the test data may already be used or the API already registered.
- It is necessary to have the Node service running to make the certificate change for the requests, otherwise it will not work.
- We are working on adding more requests to the Postman collection.
- This collection is a testing guide and is recommended for testing purposes only.


