This section describes the procedures to request new features and enhancements, report bugs, and the workflows implemented to manage them.

- [Feature Request Procedure](#41-feature-request-procedure)
- [Bug Report Procedure](#42-bug-report-procedure)
- [Feature LifeCycle](#43-feature-lifecycle)

## **4.1. Feature Request Procedure**

Project features go through a discussion and approval process.
To propose a New Feature, TFS uses the issues on its GitLab code repository.

**Important**: A feature request is about functionality, not about implementation details.

- Describe WHAT you are proposing, and WHY it is important.
- DO NOT describe HOW to do it. This is done when the new feature is approved by TSC by populating the design details.

Two kind of requests are considered in this procedure:

- **New Feature**: a big change that potentially affects a number of components and requires an appropriate design phase.
- **Enhancement**: a relatively small change enhancing TFS that does not require a design phase.


<h3><u>Steps:</h3></u>

1. Go to [New Issue](https://labs.etsi.org/rep/tfs/controller/-/issues/new) page `https://labs.etsi.org/rep/tfs/controller/-/issues/new`.
    - You need to be authenticated.


2. Create a New Issue for your feature
    - Title: A concise high level description of your feature (see some other examples in GitLab)
    - Type: Issue
    - Description: Choose the "new-feature" or "enhancement" project templates and fill-in the auto-generated template describing the feature/enhancement.
    - Labels:
        - Select the type of request: `type::new-feature` / `type::enhancement`
        - If you foresee the components affected by the request, pick the appropriate labels for them.
            - Component labels have the form `comp-<component-name>`.
        - PLEASE: Do not set other types of labels (to be set by TSC).
    - PLEASE: Do not set the following fields (to be set by TSC): EPIC, Assignee, Milestone, Weight, Due Date
    - Submit the Issue


3. Interact with the TSC and the Community through the issue.
    - TSC will review your request. If it makes sense and its purpose is clear, it will be approved. Otherwise, TSC will provide questions for clarification.


<h3><u>Designing a Feature:</h3></u>

Once a feature has been approved, the design phase starts.
The design should be included within the description of the feature (GitLab issue description) by concatenating the Design Feature Template (see below) and properly filling it in. In case the feature description becomes too long, attached files could be included to the feature.

The design is expected to be socialized with the relevant stakeholders (e.g. MDLs and TSC).
Dedicated slots can be allocated in the TECH calls on a per-request basis to discuss and refine it.

For writing the design, you can check the design of existing features or use the design template below.


<h3><u>Templates:</h3></u>

**New feature / Enhancement request template:**

```
# Proposers

- name-of-proposer-1 (institution-of-proposer-1)
- name-of-proposer-2 (institution-of-proposer-2)
...

# Description

Describe your proposal in ~1000 characters.
You can reference external content listed in section "References" as [Ref-1].

# Demo or definition of done

Describe which high level conditions needs to be fulfilled to demonstrate this feature implementation is completed.
You can reference external content (example, demo paper) listed in section "References" as [Ref-2].

# References

1. [Reference name](https://reference-url)
2. Author1, Author2, Author3, et. al., “My demo using feature,” in Conference-Name Demo Track, 20XX.
```

**Feature design Template:**

```
# Feature Design

## Clarifications to Expected Behavior Changes

Existing component logic and workflows between components that need to be altered to realize this feature.
Remember to justify these changes.
...

## References

List of relevant references for this feature.
...

## Assumptions

Enumerate the assumptions for this feature, e.g., fix XXX is implemented and merged, specific configurations, specific
components deployed.
...

## Impacted Components

List of impacted components: Context, Device, Service, PathComp, Slice, Monitoring, Automation, Policy, Compute, etc.
Just an enumeration, elaboration of impacts is done below.

## Component1 Impact

Describe impact (changes) on component1.
...

## Component2 Impact

Describe impact (changes) on component2.
...

## Testing

Describe test sets (unitary and integration) to be carried out.
This section can include/reference external experiments, demo papers, etc.
...
```

## **4.2. Bug Report Procedure**

Project bugs go through a review, confirmation, and resolution process. To report a Bug, TFS uses the issues on its GitLab code repository.

**Important**: New bugs must be properly documented. Please, provide details on:

- the details on the deployment environment (Operating System, MicroK8s, etc.)
- the TeraFlowSDN version (or branch/commit)
- the TFS deployment settings (components, particular configurations, etc.)
- the particular sequence of actions that resulted in the bug
- the TFS components affected by the bug (if you know them)
- the expected behavior (if you know it)

Without this minimal information, it will/might be difficult to reproduce and resolve the bug, as well as validating the completeness of the solution.


<h3><u>Steps:</h3></u>

1. Go to [New Issue](https://labs.etsi.org/rep/tfs/controller/-/issues/new) page `https://labs.etsi.org/rep/tfs/controller/-/issues/new`.
    - You need to be authenticated.

2. Create a New Issue for your bug
    - Title: A concise high level description of your bug (see some other examples in GitLab)
    - Type: Issue
    - Description: Choose the "bug" project template and fill-in the auto-generated template describing the bug.
    - Labels:
        - Select the type of request: `type::bug`
        - If you foresee the components affected by the bug, pick the appropriate labels for them.
            - Component labels have the form `comp-<component-name>`.
        - PLEASE: Do not set other types of labels (to be set by TSC).
    - PLEASE: Do not set the following fields (to be set by TSC): EPIC, Assignee, Milestone, Weight, Due Date
    - Submit the Issue


3. Interact with the TSC and the Community through the issue.
    - TSC will review your reported bug and try to reproduce it. If we succeed in reproducing it, we will mark it as confirmed, and include its resolution in the development plans. Otherwise, TSC will provide questions for clarification.


## **4.3. Feature LifeCycle**

Once approved, a feature request could transition through the following steps:

- **Approved**: Feature approved by TSC; design phase can start.
- **Design**: Feature under design; discussing on HOW to do it.
- **Development**: Design approved; feature under development/implementation.
- **Testing and Review**: Feature implemented and under review and testing by the developers and the community.
- **Completed**: Testing and review completed, and feature merged.
- **Abandoned**: Feature abandoned.

**Important**: An approved feature is not a guarantee for implementation.
Implementing a feature requires resources, and resources come from the members, participants and individual contributors integrating the TFS Community, which might have prioritized the development of other features based on their own interests and the interests expressed by the LG, the TSC, and the MDGs.

Once a Feature is mature, e.g., Testing, Review, Completed, it can be accepted for inclusion in a specific Release. This is accomplished by including the issue ticket in the respective EPIC "_ReleaseX.Y_". For instance, to see the Features included in Release X.Y, check EPIC "_ReleaseX.Y_".
