# Robot Framework

## Steps to Test

To run any test locally you will need *docker* and *docker-compose* installed in order run services and execute test plan. Steps will be:

* **Run All Services**: See section [Run All CAPIF Services](../../gettingstarted/howtorun.md#run-all-capif-services-locally-with-docker-images)

* **Run desired tests**: At this point we have 2 options:

  * **Using helper script**: [Script Test Execution](#script-test-execution)
  * **Build robot docker image and execute manually robot docker**: [Manual Build And Test Execution](#manual-build-and-test-execution)


## Script Test Execution
This script will build robot docker image if it's need and execute tests selected by "include" option. Just go to service folder, execute and follow steps.
```
./run_capif_tests.sh --include <TAG>
```
Results will be stored at <REPOSITORY_FOLDER>/results

Please check parameters (include) under *Test Execution* at [Manual Build And Test Execution](#manual-build-and-test-execution).

### Mock Server
Some tests on Test Plans require mockserver. That mock server must be deployed and reachable by Robot Framework and CCF under test.

To run Mock Server locally you can just execute the next script:
```
cd services
./run_mock_server.sh
```

If you want to launch only tests that not needed mockserver, just add "--exclude mockserver" parameter to robot execution:
```
./run_capif_tests.sh --include <TAG> --exclude mockserver
```

## Manual Build And Test Execution

* **Build Robot docker image**:
```
cd tools/robot
docker build . -t capif-robot-test:latest
```

* **Tests Execution**:
  
Execute all tests locally:
```
<PATH_TO_REPOSITORY>=path in local machine to repository cloned.
<PATH_RESULT_FOLDER>=path to a folder on local machine to store results of Robot Framework execution.
<CAPIF_HOSTNAME>=Is the hostname set when run.sh is executed, by default it is capifcore.
<CAPIF_HTTP_PORT>=This is the port to reach when robot framework want to reach CAPIF deployment using http, this should be set to port without TLS set on Nginx, 8080 by default.
<CAPIF_HTTPS_PORT>=This is the port to be used when we want to use https connection, this should be set to port with TLS set on Nginx, 443 by default
<CAPIF_REGISTER>=This is the hostname of register service deployed. By default it is register.
<CAPIF_REGISTER_PORT>=This is the port to be used to reach register service deployed. By default it is 8084.
<CAPIF_VAULT>=This is the hostname of vault service. By default it is vault.
<CAPIF_VAULT_PORT>=This is the port to be used to reach vault service. By default it is 8200.
<CAPIF_VAULT_TOKEN>=Vault token to be used on request through vault. By default it is "read-ca-token".
<MOCK_SERVER_URL>=Setup Mock server url to be used in notifications at tests marked with mockserver tag. By default it is not set.

To execute all tests run :
docker run -ti --rm --network="host" \
    --add-host host.docker.internal:host-gateway \
    --add-host vault:host-gateway \
    --add-host register:host-gateway \
    --add-host mockserver:host-gateway \
    -v <PATH_TO_REPOSITORY>/tests:/opt/robot-tests/tests \
    -v <PATH_RESULT_FOLDER>:/opt/robot-tests/results capif-robot-test:latest  \
    --variable CAPIF_HOSTNAME:$CAPIF_HOSTNAME \
    --variable CAPIF_HTTP_PORT:$CAPIF_HTTP_PORT \
    --variable CAPIF_HTTPS_PORT:$CAPIF_HTTPS_PORT \
    --variable CAPIF_REGISTER:$CAPIF_REGISTER \
    --variable CAPIF_REGISTER_PORT:$CAPIF_REGISTER_PORT \
    --variable CAPIF_VAULT:$CAPIF_VAULT \
    --variable CAPIF_VAULT_PORT:$CAPIF_VAULT_PORT \
    --variable CAPIF_VAULT_TOKEN:$CAPIF_VAULT_TOKEN \
    --variable MOCK_SERVER_URL:$MOCK_SERVER_URL \
    --include all
```

Execute specific tests locally:
```
To run more specific tests, for example, only one functionality:
<TAG>=Select one from list:
  "capif_api_acl",
  "capif_api_auditing_service",
  "capif_api_discover_service",
  "capif_api_events",
  "capif_api_invoker_management",
  "capif_api_logging_service",
  "capif_api_provider_management",
  "capif_api_publish_service",
  "capif_security_api

And Run:
docker run -ti --rm --network="host" \
    --add-host host.docker.internal:host-gateway \
    --add-host vault:host-gateway \
    --add-host register:host-gateway \
    --add-host mockserver:host-gateway \
    -v <PATH_TO_REPOSITORY>/tests:/opt/robot-tests/tests \
    -v <PATH_RESULT_FOLDER>:/opt/robot-tests/results capif-robot-test:latest  \
    --variable CAPIF_HOSTNAME:$CAPIF_HOSTNAME \
    --variable CAPIF_HTTP_PORT:$CAPIF_HTTP_PORT \
    --variable CAPIF_HTTPS_PORT:$CAPIF_HTTPS_PORT \
    --variable CAPIF_REGISTER:$CAPIF_REGISTER \
    --variable CAPIF_REGISTER_PORT:$CAPIF_REGISTER_PORT \
    --variable CAPIF_VAULT:$CAPIF_VAULT \
    --variable CAPIF_VAULT_PORT:$CAPIF_VAULT_PORT \
    --variable CAPIF_VAULT_TOKEN:$CAPIF_VAULT_TOKEN \
    --variable MOCK_SERVER_URL:$MOCK_SERVER_URL \
    --include <TAG>
```

## Test result review

In order to Review results after tests, you can check general report at <PATH_RESULT_FOLDER>/report.html or if you need more detailed information <PATH_RESULT_FOLDER>/log.html, example:

* Report:
![Report](./robot_report_example.png)

* Detailed information:
![Log](./robot_log_example.png)

**NOTE: If you need more detail at Robot Framework Logs you can set log level option just adding to command --loglevel DEBUG**

