- [Run All CAPIF Services locally with Docker images](#run-all-capif-services-locally-with-docker-images)
- [Run All CAPIF Services locally with Docker images and deploy monitoring stack](#run-all-capif-services-locally-with-docker-images-and-deploy-monitoring-stack)
- [Run each service using Docker](#run-each-service-using-docker)
- [Run each service using Python](#run-each-service-using-python)

Capif services are developed under [services folder](https://labs.etsi.org/rep/ocf/capif/-/tree/main/services).

### Run All CAPIF Services locally with Docker images
To run using docker and docker compose, version 2.10 or higher, you must ensure you have that tools installed at your machine. Also to simplify the process, we have 3 script to control docker images to deploy, check and cleanup.

To run all CAPIF APIs locally using docker and docker-compose you can execute:
```
cd services/

./run.sh
```
This will build and run all services using docker images, including mongodb and nginx locally and in background, and import ca.crt to nginx.

Nginx deployed by default use **capifcore** hostname, but can add a parameter when run.sh is executed setting a different hostname, for example,
```
./run.sh -c openshift.evolved-5g.eu
```

Also you can run monitoring just using option -m true, for example:
```
./run.sh -m true
./run.sh -m true -c openshift.evolved-5g.eu
```

If you want to check if all CAPIF services are running properly in local machine after execute run.sh, we can use:
```
./check_services_are_running.sh
```
This shell script will return 0 if all services are running properly.

When we need to stop all CAPIF services, we can use next bash script:
```
./clean_capif_docker_services.sh -a
```

NOTE: You can use different flags if you only want to stop some of them, please check help using
```
./clean_capif_docker_services.sh -h

Usage: clean_capif_docker_services.sh <options>
       -c : clean capif services
       -v : clean vault service
       -r : clean register service
       -m : clean monitoring service
       -a : clean all services
       -h : show this help
```

This shell script will remove and clean all CAPIF services started previously with run.sh

On the other hand you can check logs using show_logs.sh script, please check options:
```
./show_logs.sh
You must specify an option before run script.
Usage: ./show_logs.sh <options>
       -c : Show capif services
       -v : Show vault service
       -r : Show register service
       -m : Show monitoring service
       -a : Show all services
       -f : Follow log output
       -h : Show this help
```
You can also use option -f in order to live follow log output

### Run All CAPIF Services locally with Docker images and deploy monitoring stack
It is now possible to deploy a monitoring stack for CAPIF with Grafana, Prometheus, FluentBit, Loki, Cadvisor, Tempo and Opentelemetry.

To deploy CAPIF together with the monitoring stack, it is only necessary to execute the following.

```
./run.sh -m true
```

After they have been built, the different panels can be consulted in Grafana at the url

```
http://localhost:3000
```

By default, the monitoring option is set to false. Once up, all data sources and dashboards are automatically provisioned

### Run each service using Docker

Also you can run service by service using docker:
```
cd <Service>
docker build -t capif_security .
docker run -p 8080:8080 capif_security
```

### Run each service using Python

Run using python
```
cd <Service>
pip3 install -r requirements.txt
python3 -m <service>
```