This page describes how to create a Vagrant Box, using the base virtual machine configured in [Oracle Virtual Box](./1.1.2.-Oracle-Virtual-Box).

# Virtual Machine specifications
Most of the specifications can be as specified in the [Oracle Virtual Box](./1.1.2.-Oracle-Virtual-Box) page, however, there are a few particularities to Vagrant that must be accommodated, such as:
- Virtual Hard Disk
  - Size: 60GB (at least)
  - **Type**: VMDK

![spaces_huDzAu5hmjUdNzCGBBbL_uploads_jrerlmLyZWi5f2Tzb7xY_Screenshot_from_2023-07-10_18-13-43](uploads/23ff9a3d6884646f7859a29d8f5ab934/spaces_huDzAu5hmjUdNzCGBBbL_uploads_jrerlmLyZWi5f2Tzb7xY_Screenshot_from_2023-07-10_18-13-43.webp)

Also, before initiating the VM and installing the OS, we'll need to:
- Disable Floppy in the 'Boot Order'
- Disable audio
- Disable USB
- Ensure Network Adapter 1 is set to NAT

# Network configurations
At Network Adapt 1, the following port-forwarding rule must be set.

| Name | Protocol | Host IP | Host Port | Guest IP | Guest Port |
| - | - | - | - | - | - |
| SSH | TCP | | **2222** | | 22 |

![Screenshot_from_2023-07-10_18-25-18](uploads/ced8e7b1133d6831e0c203801b6ba448/Screenshot_from_2023-07-10_18-25-18.png)

# Installing the OS

For a Vagrant Box, it is generally suggested that the ISO's server version is used, as it is intended to be used via SSH, and any web GUI is expected to be forwarded to the host.

![Screenshot_from_2023-07-10_18-41-49](uploads/063d318dba47b72856ebb6d9a9b4390e/Screenshot_from_2023-07-10_18-41-49.png)

![Screenshot_from_2023-07-10_18-42-30](uploads/9e3879f84786c891af526cbea2de58e7/Screenshot_from_2023-07-10_18-42-30.png)

![Screenshot_from_2023-07-10_18-42-45](uploads/e615cc7a5e03623ffdf62a310ca86cd6/Screenshot_from_2023-07-10_18-42-45.png)

Make sure the disk is not configured as an LVM group!

![Screenshot_from_2023-07-10_18-43-16](uploads/7ab80c83d6c01c255969f4da1691eb85/Screenshot_from_2023-07-10_18-43-16.png)

## Vagrant ser
Vagrant expects by default, that in the box's OS exists the user `vagrant` with the password also being `vagrant`.

![Screenshot_from_2023-07-10_18-54-12](uploads/39e1b5868733d40c12d86bdde165ede0/Screenshot_from_2023-07-10_18-54-12.png)

## SSH

Vagrant uses SSH to connect to the boxes, so installing it now will save the hassle of doing it later.

![Screenshot_from_2023-07-10_18-54-48](uploads/5ecded27ab7966a4748ea5c25f98ab13/Screenshot_from_2023-07-10_18-54-48.png)

## Features server snaps

Do not install featured server snaps. It will be done manually [later](./1.-Deployment-Guide/1.2.-Install-Microk8s) to illustrate how to uninstall and reinstall them in case of trouble with.

## Updates

Let the system install and upgrade the packages. This operation might take some minutes depending on how old is the Optical Drive ISO image you use and your Internet connection speed.

## Upgrade the Ubuntu distribution
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```
- If asked to restart services, restart the default ones proposed.
- Restart the VM when the installation is completed.

### Install VirtualBox Guest Additions
On VirtualBox Manager, open the VM main screen. If you are running the VM in headless 
mode, right-click over the VM in the VirtualBox Manager window, and click "Show".
If a dialog informing about how to leave the interface of the VM is shown, confirm 
by pressing the "Switch" button. The interface of the VM should appear.

Click the menu "Device > Insert Guest Additions CD image..."

On the VM terminal, type:
```bash
sudo apt-get install -y linux-headers-$(uname -r) build-essential dkms
  # This command might take some minutes depending on your VM specs and your Internet access speed.
sudo mount /dev/cdrom /mnt/
cd /mnt/
sudo ./VBoxLinuxAdditions.run
  # This command might take some minutes depending on your VM specs.
sudo reboot
```

# ETSI TFS Installation
After this, proceed to [1.2. Install Microk8s](./1.-Deployment-Guide/1.2.-Install-Microk8s), after which, return to this wiki to finish the Vagrant Box creation.

# Box configuration and creation
Make sure the ETSI TFS controller is correctly configured. **You will not be able to change it after!**

It is advisable to do the next configurations from a host's terminal, via a SSH connection.
```bash
ssh -p 2222 vagrant@127.0.0.1
```

## Set root password
Set the root password to `vagrant`.
```bash
sudo passwd root
```

## Set the superuser
Set up the Vagrant user so that it’s able to use sudo without being prompted for a password.
Anything in the `/etc/sudoers.d/*` directory is included in the sudoers privileges when created by the root user.
Create a new sudo file.
```bash
sudo visudo -f /etc/sudoers.d/vagrant
```
and add the following lines
```text
# add vagrant user
vagrant ALL=(ALL) NOPASSWD:ALL
```
You can now test that it works by running a simple command.
```bash
sudo pwd
```
Issuing this command should result in an immediate response without a request for a password.

## Install the Vagrant key
Vagrant uses a default set of SSH keys for you to directly connect to boxes via the CLI command `vagrant ssh`, after which it creates a new set of SSH keys for your new box. Because of this, we need to load the default key to be able to access the box after created.
```bash
chmod 0700 /home/vagrant/.ssh
wget --no-check-certificate https://raw.github.com/mitchellh/vagrant/master/keys/vagrant.pub -O /home/vagrant/.ssh/authorized_keys
chmod 0600 /home/vagrant/.ssh/authorized_keys
chown -R vagrant /home/vagrant/.ssh
```

## Configure the OpenSSH Server
Edit the `/etc/ssh/sshd_config` file:
```bash
sudo vim /etc/ssh/sshd_config
```
And uncomment the following line:
```bash
AuthorizedKeysFile %h/.ssh/authorized_keys
```
Then restart SSH.
```bash
sudo service ssh restart
```

## Package the box
Before you package the box, if you intend to make your box public, it is best to clean your bash history with:
```bash
history -c
```
Exit the SSH connection, and **at you're host machine**, package the VM:
```bash
vagrant package --base teraflowsdncontroller --output teraflowsdncontroller.box
```

## Test run the box
Add the base box to you local Vagrant box list:
```bash
vagrant box add --name teraflowsdncontroller ./teraflowsdncontroller.box
```
Now you should try to run it, for that you'll need to create a **Vagrantfile**. For a simple run, this is the minimal required code for this box:
```ruby
# -*- mode: ruby -*-
# vi: set ft=ruby :

Vagrant.configure("2") do |config|
  config.vm.box = "teraflowsdncontroller"
  config.vm.box_version = "1.1.0"
  config.vm.network :forwarded_port, host: 8080 ,guest: 80
end
```
Now you'll be able to spin up the virtual machine by issuing the command:
```bash
vagrant up
```
And connect to the machine using:
```bash
vagrant ssh
```

# Pre-configured boxes
If you do not wish to create your own Vagrant Box, you can use one of the existing ones created by TFS contributors.
- [davidjosearaujo/teraflowsdncontroller](https://app.vagrantup.com/davidjosearaujo/boxes/teraflowsdncontroller)
- ... <!-- Should create and host one at ETSI!! -->

To use them, you simply have to create a Vagrantfile and run `vagrant up controller` in the same directory. The following example Vagrantfile already allows you to do just that, with the bonus of exposing the multiple management GUIs to your `localhost`.
```ruby
Vagrant.configure("2") do |config|
  
  config.vm.define "controller" do |controller|
    controller.vm.box = "davidjosearaujo/teraflowsdncontroller"
    controller.vm.network "forwarded_port", guest: 80, host: 8080     # WebUI
    controller.vm.network "forwarded_port", guest: 8084, host: 50750  # Linkerd Viz Dashboard
    controller.vm.network "forwarded_port", guest: 8081, host: 8081   # CockroachDB Dashboard
    controller.vm.network "forwarded_port", guest: 8222, host: 8222   # NATS Dashboard
    controller.vm.network "forwarded_port", guest: 9000, host: 9000   # QuestDB Dashboard
    controller.vm.network "forwarded_port", guest: 9090, host: 9090   # Prometheus Dashboard
    
    # Setup Linkerd Viz reverse proxy
    ## Copy config file
    controller.vm.provision "file" do |f|
      f.source = "./reverse-proxy-linkerdviz.sh"
      f.destination = "./reverse-proxy-linkerdviz.sh"
    end
    ## Execute configuration file
    controller.vm.provision "shell" do |s|
      s.inline = "chmod +x ./reverse-proxy-linkerdviz.sh && ./reverse-proxy-linkerdviz.sh"
    end

    # Update controller source code to the desired branch
    if ENV['BRANCH'] != nil
      controller.vm.provision "shell" do |s|
        s.inline = "cd ./tfs-ctrl && git pull && git switch " + ENV['BRANCH']
      end
    end

  end
end
```
This Vagrantfile also allows for **optional repository updates** on startup by running the command with a specified environment variable `BRANCH`
```bash
BRANCH=develop vagrant up controller
```

## Linkerd DNS rebinding bypass
Because of Linkerd's security measures against DNS rebinding, a reverse proxy, that modifies the request's header `Host` field, is needed to expose the GUI to the host. The previous Vagrantfile already deploys such configurations, for that, all you need to do is create the `reverse-proxy-linkerdviz.sh` file in the same directory. The content of this file is displayed below.
```bash
# Install NGINX
sudo apt update && sudo apt install nginx -y

# NGINX reverse proxy configuration
echo 'server {
    listen 8084;

    location / {
        proxy_pass http://127.0.0.1:50750;
        proxy_set_header Host localhost;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}' > /home/vagrant/expose-linkerd

# Create symlink of the NGINX configuration file
sudo ln -s /home/vagrant/expose-linkerd /etc/nginx/sites-enabled/

# Commit the reverse proxy configurations
sudo systemctl restart nginx

# Enable start on login
echo "linkerd viz dashboard &" >> .profile

# Start dashboard
linkerd viz dashboard &

echo "Linkerd Viz dashboard running!"
```
