This section describes how to deploy TeraFlowSDN controller on top of MicroK8s using the 
environment configured in the previous sections.


## Install prerequisites
```bash
sudo apt-get install -y git curl jq
```


## Clone the Git repository of the TeraFlowSDN controller
Clone from ETSI-hosted GitLab code repository:
```bash
mkdir ~/tfs-ctrl
git clone https://labs.etsi.org/rep/tfs/controller.git ~/tfs-ctrl
```

__Important__: The original H2020-TeraFlow project hosted on GitLab.com has been 
archieved and will not receive further contributions/updates.
Please, clone from [ETSI-hosted GitLab code repository](https://labs.etsi.org/rep/tfs/controller).


## Checkout the appropriate Git branch
TeraFlowSDN controller versions can be found in the appropriate release tags and/or branches as described in [Home > Versions](/Home#versions).

By default the branch *master* is checked out and points to the latest stable version of the TeraFlowSDN controller, while branch *develop* contains the latest developments and contributions under test and validation.

To switch to the appropriate branch run the following command, changing `develop` by the name of the branch you want to deploy:
```bash
cd ~/tfs-ctrl
git checkout develop
```


## Prepare a deployment script with the deployment settings
Create a new deployment script, e.g., `my_deploy.sh`, adding the appropriate settings as 
follows.
This section provides just an overview of the available settings. An example [`my_deploy.sh`](https://labs.etsi.org/rep/tfs/controller/-/blob/master/my_deploy.sh) script is provided in the root folder of the project for your convenience with full description of all the settings.

__Note__: The example `my_deploy.sh` script provides reasonable settings for deploying a functional and complete enough TeraFlowSDN controller, and a brief description of their meaning. To see extended descriptions, check scripts in the `deploy` folder.

```bash
cd ~/tfs-ctrl
tee my_deploy.sh >/dev/null << EOF
# ----- TeraFlowSDN ------------------------------------------------------------
export TFS_REGISTRY_IMAGES="http://localhost:32000/tfs/"
export TFS_COMPONENTS="context device ztp monitoring pathcomp service slice nbi webui load_generator"
export TFS_IMAGE_TAG="dev"
export TFS_K8S_NAMESPACE="tfs"
export TFS_EXTRA_MANIFESTS="manifests/nginx_ingress_http.yaml"
export TFS_GRAFANA_PASSWORD="admin123+"
export TFS_SKIP_BUILD=""

# ----- CockroachDB ------------------------------------------------------------
export CRDB_NAMESPACE="crdb"
export CRDB_EXT_PORT_SQL="26257"
export CRDB_EXT_PORT_HTTP="8081"
export CRDB_USERNAME="tfs"
export CRDB_PASSWORD="tfs123"
export CRDB_DATABASE="tfs"
export CRDB_DEPLOY_MODE="single"
export CRDB_DROP_DATABASE_IF_EXISTS="YES"
export CRDB_REDEPLOY=""

# ----- NATS -------------------------------------------------------------------
export NATS_NAMESPACE="nats"
export NATS_EXT_PORT_CLIENT="4222"
export NATS_EXT_PORT_HTTP="8222"
export NATS_REDEPLOY=""

# ----- QuestDB ----------------------------------------------------------------
export QDB_NAMESPACE="qdb"
export QDB_EXT_PORT_SQL="8812"
export QDB_EXT_PORT_ILP="9009"
export QDB_EXT_PORT_HTTP="9000"
export QDB_USERNAME="admin"
export QDB_PASSWORD="quest"
export QDB_TABLE_MONITORING_KPIS="tfs_monitoring_kpis"
export QDB_TABLE_SLICE_GROUPS="tfs_slice_groups"
export QDB_DROP_TABLES_IF_EXIST="YES"
export QDB_REDEPLOY=""

EOF
```

The settings are organized in 4 sections:
- Section `TeraFlowSDN`:
  - `TFS_REGISTRY_IMAGE` enables to specify the private Docker registry to be used, by default, we assume to use the Docker respository enabled in MicroK8s.
  - `TFS_COMPONENTS` specifies the components their Docker image will be rebuilt, uploaded to the private Docker registry, and deployed in Kubernetes.
  - `TFS_IMAGE_TAG` defines the tag to be used for Docker images being rebuilt and uploaded to the private Docker registry.
  - `TFS_K8S_NAMESPACE` specifies the name of the Kubernetes namespace to be used for deploying the TFS components.
  - `TFS_EXTRA_MANIFESTS` enables to provide additional manifests to be applied into the Kubernetes environment during the deployment. Typical use case is to deploy ingress controllers, service monitors for Prometheus, etc.
  - `TFS_GRAFANA_PASSWORD` lets you specify the password you want to use for the `admin` user of the Grafana instance being deployed and linked to the Monitoring component.
  - `TFS_SKIP_BUILD`, if set to `YES`, prevents rebuilding the Docker images. That means, the deploy script will redeploy existing Docker images without rebuilding/updating them.

- Section `CockroachDB`: enables to configure the deployment of the backend [CockroachDB](https://www.cockroachlabs.com/) database.
  - Check example script [`my_deploy.sh`](https://labs.etsi.org/rep/tfs/controller/-/blob/master/my_deploy.sh) for further details.

- Section `NATS`: enables to configure the deployment of the backend [NATS](https://nats.io/) message broker.
  - Check example script [`my_deploy.sh`](https://labs.etsi.org/rep/tfs/controller/-/blob/master/my_deploy.sh) for further details.

- Section `QuestDB`: enables to configure the deployment of the backend [QuestDB](https://questdb.io/) timeseries database.
  - Check example script [`my_deploy.sh`](https://labs.etsi.org/rep/tfs/controller/-/blob/master/my_deploy.sh) for further details.


## Confirm that MicroK8s is running

Run the following command:
```bash
microk8s status
```

If it is reported `microk8s is not running, try microk8s start`, run the following command to start MicroK8s:
```bash
microk8s start
```

Confirm everything is up and running:

1. Periodically [Check the status of Kubernetes](/1.-Deployment-Guide/1.2.-Install-MicroK8s#check-status-of-kubernetes-and-addons) until you see the addons \[dns, ha-cluster, helm3, hostpath-storage, ingress, registry, storage\] in the enabled block.
2. Periodically [Check Kubernetes resources](/1.-Deployment-Guide/1.2.-Install-MicroK8s#check-all-resources-in-kubernetes) until all pods are **Ready** and **Running**.


## Deploy TFS controller
First, source the deployment settings defined in the previous section.
This way, you do not need to specify the environment variables in each and every command you execute to operate the TFS controller.
Be aware to re-source the file if you open new terminal sessions.
Then, run the following command to deploy TeraFlowSDN controller on top of the MicroK8s Kubernetes platform.

```bash
cd ~/tfs-ctrl
source my_deploy.sh
./deploy/all.sh
```

The script performs the following steps:
- Executes script `./deploy/crdb.sh` to automate deployment of CockroachDB database used by Context component.
  - The script automatically checks if CockroachDB is already deployed.
  - If there are settings instructing to drop the database and/or redeploy CockroachDB, it does the appropriate actions to honor them as defined in previous section.
- Executes script `./deploy/nats.sh` to automate deployment of NATS message broker used by Context component.
  - The script automatically checks if NATS is already deployed.
  - If there are settings instructing to redeploy the message broker, it does the appropriate actions to honor them as defined in previous section.
- Executes script `./deploy/qdb.sh` to automate deployment of QuestDB timeseries database used by Monitoring component.
  - The script automatically checks if QuestDB is already deployed.
  - If there are settings instructing to redeploy the timeseries database, it does the appropriate actions to honor them as defined in previous section.
- Executes script `./deploy/tfs.sh` to automate deployment of TeraFlowSDN.
  - Creates the namespace defined in `TFS_K8S_NAMESPACE`
  - Creates secrets for CockroachDB, NATS, and QuestDB to be used by Context and Monitoring components.
  - Builds the Docker images for the components defined in `TFS_COMPONENTS`
  - Tags the Docker images with the value of `TFS_IMAGE_TAG`
  - Pushes the Docker images to the repository defined in `TFS_REGISTRY_IMAGE`
  - Deploys the components defined in `TFS_COMPONENTS`
  - Creates the file `tfs_runtime_env_vars.sh` with the environment variables for the components defined in `TFS_COMPONENTS` defining their local host addresses and their port numbers.
  - Applies extra manifests defined in `TFS_EXTRA_MANIFESTS` such as:
    - Creating an ingress controller listening at port 80 for HTTP connections to enable external access to the TeraFlowSDN WebUI, Grafana Dashboards, and Compute NBI interfaces.
    - Deploying service monitors to enable monitoring the performance of the components, device drivers and service handlers.
  - Initialize and configure the Grafana dashboards (if Monitoring component is deployed)
- Report a summary of the deployment
  - See [Show Deployment and Logs](./1.5.-Show-Deployment-and-Logs)
