This section describes how to configure the Python environment to run experiments and 
develop code for the ETSI TeraFlowSDN controller.
In particular, we use [PyEnv](https://github.com/pyenv/pyenv) to install the appropriate 
version of Python and manage the virtual environments.


## Upgrade the Ubuntu distribution
Skip this step if you already did it during the installation of your machine.
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```


## Install PyEnv dependencies
```bash
sudo apt-get install -y make build-essential libssl-dev zlib1g-dev libbz2-dev libreadline-dev libsqlite3-dev wget \
    curl llvm git libncursesw5-dev xz-utils tk-dev libxml2-dev libxmlsec1-dev libffi-dev liblzma-dev
```


## Install PyEnv

We recommend installing PyEnv through  
[PyEnv Installer](https://github.com/pyenv/pyenv-installer).
Below you can find the instructions, but we refer you to the link for updated 
instructions.

```bash
curl https://pyenv.run | bash
# When finished, edit ~/.bash_profile // ~/.profile // ~/.bashrc as the installer proposes.
# In general, it means to append the following lines to ~/.bashrc:
export PYENV_ROOT="$HOME/.pyenv"
command -v pyenv >/dev/null || export PATH="$PYENV_ROOT/bin:$PATH"
eval "$(pyenv init -)"
eval "$(pyenv virtualenv-init -)"
```

In case .bashrc is not linked properly to your profile, you may need to append the 
following line into your local .profile file:

```bash
# Open ~/.profile and append this line:
+source "$HOME"/.bashrc
```


## Restart the machine
Restart the machine for all the changes to take effect.
```bash
sudo reboot
```


## Install Python 3.9 over PyEnv

ETSI TeraFlowSDN uses Python 3.9 by default.
You should install the latest stable update of Python 3.9, i.e., avoid "-dev" versions.
To find the latest version available in PyEnv, you can run the following command:

```bash
pyenv install --list | grep " 3.9"
```

At the time of writing, this command will output the following list:

```
  3.9.0
  3.9-dev
  3.9.1
  3.9.2
  3.9.4
  3.9.5
  3.9.6
  3.9.7
  3.9.8
  3.9.9
  3.9.10
  3.9.11
  3.9.12
  3.9.13
  3.9.14 
  3.9.15
  3.9.16 ** always select the latest version **
```

Therefore, the latest stable version is Python 3.9.16.
To install this version, you should run:

```bash
pyenv install 3.9.16
    # This command might take some minutes depending on your Internet connection speed 
    # and the performance of your machine.
```


## Create the Virtual Environment for TeraFlowSDN
The following commands create a virtual environment named as `tfs` using Python 3.9 and 
associate that environment with the current folder, i.e., `~/tfs-ctrl`.
That way, when you are in that folder, the associated virtual environment will be used, 
thus inheriting the Python interpreter, i.e., Python 3.9, and the Python packages 
installed on it.

```bash
cd ~/tfs-ctrl
pyenv virtualenv 3.9.16 tfs
pyenv local 3.9.16/envs/tfs
```

After completing these commands, you should see in your prompt that now you're within 
the virtual environment `3.9.16/envs/tfs` on folder `~/tfs-ctrl`:

```
(3.9.16/envs/tfs) tfs@tfs-vm:~/tfs-ctrl$
```

In case that the correct pyenv does not get automatically activated when you change to 
the tfs-ctrl/ folder, then execute the following command:

```bash
cd ~/tfs-ctrl
pyenv activate 3.9.16/envs/tfs
```



## Install the basic Python packages within the virtual environment
From within the `3.9.16/envs/tfs` environment on folder `~/tfs-ctrl`, run the following 
commands to install the basic Python packages required to work with TeraFlowSDN.
```bash
cd ~/tfs-ctrl
./install_requirements.sh
```

Some dependencies require to re-load the session, so log-out and log-in again.


## Generate the Python code from the gRPC Proto messages and services

The components, e.g., microservices, of the TeraFlowSDN controller, in general, use a gRPC-based open API to interoperate.
All the protocol definitions can be found in sub-folder `proto` within the root project folder.
For additional details on gRPC, visit the official web-page [gRPC](https://grpc.io/).

In order to interact with the components, (re-)generate the Python code from gRPC definitions running the following command:

```bash
cd ~/tfs-ctrl
proto/generate_code_python.sh
```
