This section describe the steps needed to create a development environment for TFS components implemented in Java. Currently, ZTP and Policy components have been developed in Java (version 11) and use the [Quarkus](https://quarkus.io/) framework, which enables kubernetes-native development.

## Install JDK
To begin, make sure that you have java installed and in the correct version
```
java --version
```

If you don't have java installed you will get an error like the following:
```
Command 'java' not found, but can be installed with:

sudo apt install default-jre              # version 2:1.11-72build1, or
sudo apt install openjdk-11-jre-headless  # version 11.0.14+9-0ubuntu2
sudo apt install openjdk-17-jre-headless  # version 17.0.2+8-1
sudo apt install openjdk-18-jre-headless  # version 18~36ea-1
sudo apt install openjdk-8-jre-headless   # version 8u312-b07-0ubuntu1
```

In which case you should use the following command to install the correct version:
```
sudo apt install openjdk-11-jre-headless
```

Else you should get something like the following:
```
openjdk 11.0.18 2023-01-17
OpenJDK Runtime Environment (build 11.0.18+10-post-Ubuntu-0ubuntu120.04.1)
OpenJDK 64-Bit Server VM (build 11.0.18+10-post-Ubuntu-0ubuntu120.04.1, mixed mode, sharing)
```

## Compiling and testing existing components
In the root directory of the existing Java components you will find an executable maven wrapper named `mvnw`. You could use this executable, which is already configured in pair with the components, instead of your local maven installation. So for example if you want to compile the project you would run the following:
```
./mvnw compile
```

## VS Code Quarkus plugin
In case you are using [VS Code](https://code.visualstudio.com/) for development, we suggest to install the [official Quarkus extension](https://marketplace.visualstudio.com/items?itemName=redhat.vscode-quarkus).
The extension should be able to automatically find the current open project and integrate with the above `mvnw` maven wrapper, making it easier to control the [maven lifecycle](https://maven.apache.org/guides/introduction/introduction-to-the-lifecycle.html).
Make sure that you open the specific component directory (i.e., `src/ztp` or `src/policy`) and not the general controller one (i.e., `src`.

## New Java TFS component

### Sample Project

If you want to create a new TFS component written in Java you could generate a new Quarkus project based on the following project:

[TFS Sample Quarkus Project](https://code.quarkus.io/?e=grpc&e=kubernetes&e=container-image-jib&e=kubernetes-service-binding&e=smallrye-health&e=resteasy-reactive)

In that way, you should have most of the libraries you would need to integrate with the rest of the TFS Components. Feel free however to add or remove libraries depending on your needs.

### Initial setup

If you used the sample project above, you should have a project with a basic structure. However there are some steps that you should take before starting development.

First make sure that you copy the protobuff files, that are found in the root directory of the TFS SDN controller, to the `new-component/src/main/proto` directory.

Next you should create the following files:
* `new-component/.gitlab-ci.yml`
* `new-component/Dockerfile`
* `new-component/src/resources/application.yaml`

We suggest to copy the respective files from existing components (Automation and Policy) and change them according to your needs.