This section describes how to get access to the TeraFlowSDN controller WebUI and the monitoring Grafana dashboards.

## Access the TeraFlowSDN WebUI
If you followed the installation steps based on MicroK8s, you got an ingress controller installed that exposes on TCP port 80.

Besides, the ingress controller defines the following reverse proxy paths (on your local machine):
- `http://127.0.0.1/webui`: points to the WebUI of TeraFlowSDN.
- `http://127.0.0.1/grafana`: points to the Grafana dashboards.
  This endpoint brings access to the monitoring dashboards of TeraFlowSDN.
  The credentials for the `admin`user are those defined in the `my_deploy.sh` script, in the `TFS_GRAFANA_PASSWORD` variable.
- `http://127.0.0.1/restconf`: points to the Compute component NBI based on RestCONF. 
  This endpoint enables connecting external software, such as ETSI OpenSourceMANO NFV Orchestrator, to TeraFlowSDN.

**Note**: In the creation of the VM, a forward from host TCP port 8080 to VM's TCP port 80 is configured, so the WebUIs and REST APIs of TeraFlowSDN should be exposed on the endpoint `127.0.0.1:8080` of your local machine instead of `127.0.0.1:80`.