# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.topology_layer_protocol_name import TopologyLayerProtocolName  # noqa: F401,E501
from swagger_server import util


class TopologyPort(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, layer_protocol_name: TopologyLayerProtocolName=None, port_id: str=None):  # noqa: E501
        """TopologyPort - a model defined in Swagger

        :param layer_protocol_name: The layer_protocol_name of this TopologyPort.  # noqa: E501
        :type layer_protocol_name: TopologyLayerProtocolName
        :param port_id: The port_id of this TopologyPort.  # noqa: E501
        :type port_id: str
        """
        self.swagger_types = {
            'layer_protocol_name': TopologyLayerProtocolName,
            'port_id': str
        }

        self.attribute_map = {
            'layer_protocol_name': 'layer-protocol-name',
            'port_id': 'port-id'
        }
        self._layer_protocol_name = layer_protocol_name
        self._port_id = port_id

    @classmethod
    def from_dict(cls, dikt) -> 'TopologyPort':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The topology.Port of this TopologyPort.  # noqa: E501
        :rtype: TopologyPort
        """
        return util.deserialize_model(dikt, cls)

    @property
    def layer_protocol_name(self) -> TopologyLayerProtocolName:
        """Gets the layer_protocol_name of this TopologyPort.


        :return: The layer_protocol_name of this TopologyPort.
        :rtype: TopologyLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TopologyLayerProtocolName):
        """Sets the layer_protocol_name of this TopologyPort.


        :param layer_protocol_name: The layer_protocol_name of this TopologyPort.
        :type layer_protocol_name: TopologyLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def port_id(self) -> str:
        """Gets the port_id of this TopologyPort.


        :return: The port_id of this TopologyPort.
        :rtype: str
        """
        return self._port_id

    @port_id.setter
    def port_id(self, port_id: str):
        """Sets the port_id of this TopologyPort.


        :param port_id: The port_id of this TopologyPort.
        :type port_id: str
        """

        self._port_id = port_id
