# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_connection_connection__connection(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module connection - based on the path /connection. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.
  """
  __slots__ = ('_path_helper', '_extmethods', '__connection_id','__source_node','__target_node','__source_port','__target_port','__bandwidth','__layer_protocol_name',)

  _yang_name = 'connection'
  _yang_namespace = 'urn:connection'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__target_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    self.__layer_protocol_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={u'ETH': {}, u'OPTICAL': {}},), is_leaf=True, yang_name="layer-protocol-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='topology:layer-protocol-name', is_config=True)
    self.__connection_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="connection-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:connection', defining_module='connection', yang_type='string', is_config=True)
    self.__bandwidth = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='uint32', is_config=True)
    self.__target_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    self.__source_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    self.__source_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return [u'connection']

  def _get_connection_id(self):
    """
    Getter method for connection_id, mapped from YANG variable /connection/connection_id (string)
    """
    return self.__connection_id
      
  def _set_connection_id(self, v, load=False):
    """
    Setter method for connection_id, mapped from YANG variable /connection/connection_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_id() directly.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="connection-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:connection', defining_module='connection', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="connection-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:connection', defining_module='connection', yang_type='string', is_config=True)""",
        })

    self.__connection_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_id(self):
    self.__connection_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="connection-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:connection', defining_module='connection', yang_type='string', is_config=True)


  def _get_source_node(self):
    """
    Getter method for source_node, mapped from YANG variable /connection/source_node (leafref)
    """
    return self.__source_node
      
  def _set_source_node(self, v, load=False):
    """
    Setter method for source_node, mapped from YANG variable /connection/source_node (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_node() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_node must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)""",
        })

    self.__source_node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_node(self):
    self.__source_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)


  def _get_target_node(self):
    """
    Getter method for target_node, mapped from YANG variable /connection/target_node (leafref)
    """
    return self.__target_node
      
  def _set_target_node(self, v, load=False):
    """
    Setter method for target_node, mapped from YANG variable /connection/target_node (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_node() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="target-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_node must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)""",
        })

    self.__target_node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_node(self):
    self.__target_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)


  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /connection/source_port (leafref)
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /connection/source_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)


  def _get_target_port(self):
    """
    Getter method for target_port, mapped from YANG variable /connection/target_port (leafref)
    """
    return self.__target_port
      
  def _set_target_port(self, v, load=False):
    """
    Setter method for target_port, mapped from YANG variable /connection/target_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target_port() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="target-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)""",
        })

    self.__target_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target_port(self):
    self.__target_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="target-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='leafref', is_config=True)


  def _get_bandwidth(self):
    """
    Getter method for bandwidth, mapped from YANG variable /connection/bandwidth (uint32)
    """
    return self.__bandwidth
      
  def _set_bandwidth(self, v, load=False):
    """
    Setter method for bandwidth, mapped from YANG variable /connection/bandwidth (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bandwidth() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bandwidth must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='uint32', is_config=True)""",
        })

    self.__bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bandwidth(self):
    self.__bandwidth = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='uint32', is_config=True)


  def _get_layer_protocol_name(self):
    """
    Getter method for layer_protocol_name, mapped from YANG variable /connection/layer_protocol_name (topology:layer-protocol-name)
    """
    return self.__layer_protocol_name
      
  def _set_layer_protocol_name(self, v, load=False):
    """
    Setter method for layer_protocol_name, mapped from YANG variable /connection/layer_protocol_name (topology:layer-protocol-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_layer_protocol_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_layer_protocol_name() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={u'ETH': {}, u'OPTICAL': {}},), is_leaf=True, yang_name="layer-protocol-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='topology:layer-protocol-name', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """layer_protocol_name must be of a type compatible with topology:layer-protocol-name""",
          'defined-type': "topology:layer-protocol-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={u'ETH': {}, u'OPTICAL': {}},), is_leaf=True, yang_name="layer-protocol-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='topology:layer-protocol-name', is_config=True)""",
        })

    self.__layer_protocol_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_layer_protocol_name(self):
    self.__layer_protocol_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={u'ETH': {}, u'OPTICAL': {}},), is_leaf=True, yang_name="layer-protocol-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:connection', defining_module='connection', yang_type='topology:layer-protocol-name', is_config=True)

  connection_id = __builtin__.property(_get_connection_id, _set_connection_id)
  source_node = __builtin__.property(_get_source_node, _set_source_node)
  target_node = __builtin__.property(_get_target_node, _set_target_node)
  source_port = __builtin__.property(_get_source_port, _set_source_port)
  target_port = __builtin__.property(_get_target_port, _set_target_port)
  bandwidth = __builtin__.property(_get_bandwidth, _set_bandwidth)
  layer_protocol_name = __builtin__.property(_get_layer_protocol_name, _set_layer_protocol_name)


  _pyangbind_elements = OrderedDict([('connection_id', connection_id), ('source_node', source_node), ('target_node', target_node), ('source_port', source_port), ('target_port', target_port), ('bandwidth', bandwidth), ('layer_protocol_name', layer_protocol_name), ])


class connection(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module connection - based on the path /connection. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Basic example of network topology
  """
  __slots__ = ('_path_helper', '_extmethods', '__connection',)

  _yang_name = 'connection'
  _yang_namespace = 'urn:connection'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__connection = YANGDynClass(base=YANGListType("connection_id",yc_connection_connection__connection, yang_name="connection", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='connection-id', extensions=None), is_container='list', yang_name="connection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:connection', defining_module='connection', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_connection(self):
    """
    Getter method for connection, mapped from YANG variable /connection (list)
    """
    return self.__connection
      
  def _set_connection(self, v, load=False):
    """
    Setter method for connection, mapped from YANG variable /connection (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection() directly.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("connection_id",yc_connection_connection__connection, yang_name="connection", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='connection-id', extensions=None), is_container='list', yang_name="connection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:connection', defining_module='connection', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("connection_id",yc_connection_connection__connection, yang_name="connection", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='connection-id', extensions=None), is_container='list', yang_name="connection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:connection', defining_module='connection', yang_type='list', is_config=True)""",
        })

    self.__connection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection(self):
    self.__connection = YANGDynClass(base=YANGListType("connection_id",yc_connection_connection__connection, yang_name="connection", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='connection-id', extensions=None), is_container='list', yang_name="connection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:connection', defining_module='connection', yang_type='list', is_config=True)

  connection = __builtin__.property(_get_connection, _set_connection)


  _pyangbind_elements = OrderedDict([('connection', connection), ])


