# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of interface-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__in_unicast_pkts','__in_broadcast_pkts','__in_multicast_pkts','__in_discards','__in_errors','__in_unknown_protos','__in_fcs_errors','__out_octets','__out_pkts','__out_unicast_pkts','__out_broadcast_pkts','__out_multicast_pkts','__out_discards','__out_errors','__carrier_transitions','__last_clear',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unicast_pkts(self):
    """
    Getter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unicast_pkts
      
  def _set_in_unicast_pkts(self, v, load=False):
    """
    Setter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unicast_pkts(self):
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_broadcast_pkts(self):
    """
    Getter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_broadcast_pkts
      
  def _set_in_broadcast_pkts(self, v, load=False):
    """
    Setter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_broadcast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_broadcast_pkts(self):
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_multicast_pkts(self):
    """
    Getter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_multicast_pkts
      
  def _set_in_multicast_pkts(self, v, load=False):
    """
    Setter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_multicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_multicast_pkts(self):
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_discards(self):
    """
    Getter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_discards
      
  def _set_in_discards(self, v, load=False):
    """
    Setter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_discards() directly.

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_discards(self):
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_errors(self):
    """
    Getter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_errors
      
  def _set_in_errors(self, v, load=False):
    """
    Setter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_errors(self):
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unknown_protos(self):
    """
    Getter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unknown_protos
      
  def _set_in_unknown_protos(self, v, load=False):
    """
    Setter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unknown_protos is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unknown_protos() directly.

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unknown_protos must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unknown_protos = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unknown_protos(self):
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fcs_errors(self):
    """
    Getter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    return self.__in_fcs_errors
      
  def _set_in_fcs_errors(self, v, load=False):
    """
    Setter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fcs_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fcs_errors() directly.

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fcs_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fcs_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fcs_errors(self):
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_unicast_pkts(self):
    """
    Getter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_unicast_pkts
      
  def _set_out_unicast_pkts(self, v, load=False):
    """
    Setter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_unicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_unicast_pkts(self):
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_broadcast_pkts(self):
    """
    Getter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_broadcast_pkts
      
  def _set_out_broadcast_pkts(self, v, load=False):
    """
    Setter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_broadcast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_broadcast_pkts(self):
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_multicast_pkts(self):
    """
    Getter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_multicast_pkts
      
  def _set_out_multicast_pkts(self, v, load=False):
    """
    Setter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_multicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_multicast_pkts(self):
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_discards(self):
    """
    Getter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_discards
      
  def _set_out_discards(self, v, load=False):
    """
    Setter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_discards() directly.

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_discards(self):
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_errors(self):
    """
    Getter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_errors
      
  def _set_out_errors(self, v, load=False):
    """
    Setter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_errors(self):
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_carrier_transitions(self):
    """
    Getter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    return self.__carrier_transitions
      
  def _set_carrier_transitions(self, v, load=False):
    """
    Setter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_carrier_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_carrier_transitions() directly.

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """carrier_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__carrier_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_carrier_transitions(self):
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  in_unicast_pkts = __builtin__.property(_get_in_unicast_pkts)
  in_broadcast_pkts = __builtin__.property(_get_in_broadcast_pkts)
  in_multicast_pkts = __builtin__.property(_get_in_multicast_pkts)
  in_discards = __builtin__.property(_get_in_discards)
  in_errors = __builtin__.property(_get_in_errors)
  in_unknown_protos = __builtin__.property(_get_in_unknown_protos)
  in_fcs_errors = __builtin__.property(_get_in_fcs_errors)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)
  out_unicast_pkts = __builtin__.property(_get_out_unicast_pkts)
  out_broadcast_pkts = __builtin__.property(_get_out_broadcast_pkts)
  out_multicast_pkts = __builtin__.property(_get_out_multicast_pkts)
  out_discards = __builtin__.property(_get_out_discards)
  out_errors = __builtin__.property(_get_out_errors)
  carrier_transitions = __builtin__.property(_get_carrier_transitions)
  last_clear = __builtin__.property(_get_last_clear)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('in_unicast_pkts', in_unicast_pkts), ('in_broadcast_pkts', in_broadcast_pkts), ('in_multicast_pkts', in_multicast_pkts), ('in_discards', in_discards), ('in_errors', in_errors), ('in_unknown_protos', in_unknown_protos), ('in_fcs_errors', in_fcs_errors), ('out_octets', out_octets), ('out_pkts', out_pkts), ('out_unicast_pkts', out_unicast_pkts), ('out_broadcast_pkts', out_broadcast_pkts), ('out_multicast_pkts', out_multicast_pkts), ('out_discards', out_discards), ('out_errors', out_errors), ('carrier_transitions', carrier_transitions), ('last_clear', last_clear), ])


