# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import fatal_errors
from . import non_fatal_errors
from . import correctable_errors
class pcie(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
  """
  __slots__ = ('_path_helper', '_extmethods', '__fatal_errors','__non_fatal_errors','__correctable_errors',)

  _yang_name = 'pcie'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__fatal_errors = YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__non_fatal_errors = YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__correctable_errors = YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie']

  def _get_fatal_errors(self):
    """
    Getter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)

    YANG Description: The count of the fatal PCIe errors.
    """
    return self.__fatal_errors
      
  def _set_fatal_errors(self, v, load=False):
    """
    Setter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fatal_errors() directly.

    YANG Description: The count of the fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fatal_errors(self):
    self.__fatal_errors = YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_non_fatal_errors(self):
    """
    Getter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)

    YANG Description: The count of the non-fatal PCIe errors.
    """
    return self.__non_fatal_errors
      
  def _set_non_fatal_errors(self, v, load=False):
    """
    Setter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_non_fatal_errors() directly.

    YANG Description: The count of the non-fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """non_fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_non_fatal_errors(self):
    self.__non_fatal_errors = YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_correctable_errors(self):
    """
    Getter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)

    YANG Description: The count of the correctable PCIe errors.
    """
    return self.__correctable_errors
      
  def _set_correctable_errors(self, v, load=False):
    """
    Setter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_correctable_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_correctable_errors() directly.

    YANG Description: The count of the correctable PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """correctable_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__correctable_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_correctable_errors(self):
    self.__correctable_errors = YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

  fatal_errors = __builtin__.property(_get_fatal_errors)
  non_fatal_errors = __builtin__.property(_get_non_fatal_errors)
  correctable_errors = __builtin__.property(_get_correctable_errors)


  _pyangbind_elements = OrderedDict([('fatal_errors', fatal_errors), ('non_fatal_errors', non_fatal_errors), ('correctable_errors', correctable_errors), ])


from . import fatal_errors
from . import non_fatal_errors
from . import correctable_errors
class pcie(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state/pcie. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
  """
  __slots__ = ('_path_helper', '_extmethods', '__fatal_errors','__non_fatal_errors','__correctable_errors',)

  _yang_name = 'pcie'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__fatal_errors = YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__non_fatal_errors = YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__correctable_errors = YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie']

  def _get_fatal_errors(self):
    """
    Getter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)

    YANG Description: The count of the fatal PCIe errors.
    """
    return self.__fatal_errors
      
  def _set_fatal_errors(self, v, load=False):
    """
    Setter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fatal_errors() directly.

    YANG Description: The count of the fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fatal_errors(self):
    self.__fatal_errors = YANGDynClass(base=fatal_errors.fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_non_fatal_errors(self):
    """
    Getter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)

    YANG Description: The count of the non-fatal PCIe errors.
    """
    return self.__non_fatal_errors
      
  def _set_non_fatal_errors(self, v, load=False):
    """
    Setter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_non_fatal_errors() directly.

    YANG Description: The count of the non-fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """non_fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_non_fatal_errors(self):
    self.__non_fatal_errors = YANGDynClass(base=non_fatal_errors.non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_correctable_errors(self):
    """
    Getter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)

    YANG Description: The count of the correctable PCIe errors.
    """
    return self.__correctable_errors
      
  def _set_correctable_errors(self, v, load=False):
    """
    Setter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_correctable_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_correctable_errors() directly.

    YANG Description: The count of the correctable PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """correctable_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__correctable_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_correctable_errors(self):
    self.__correctable_errors = YANGDynClass(base=correctable_errors.correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

  fatal_errors = __builtin__.property(_get_fatal_errors)
  non_fatal_errors = __builtin__.property(_get_non_fatal_errors)
  correctable_errors = __builtin__.property(_get_correctable_errors)


  _pyangbind_elements = OrderedDict([('fatal_errors', fatal_errors), ('non_fatal_errors', non_fatal_errors), ('correctable_errors', correctable_errors), ])


