# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import interfaces
class openconfig_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /openconfig-interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model for managing network interfaces and subinterfaces.  This
module also defines convenience types / groupings for other
models to create references to interfaces:

 base-interface-ref (type) -  reference to a base interface
 interface-ref (grouping) -  container for reference to a
   interface + subinterface
 interface-ref-state (grouping) - container for read-only
   (opstate) reference to interface + subinterface

This model reuses data items defined in the IETF YANG model for
interfaces described by RFC 7223 with an alternate structure
(particularly for operational state data) and with
additional configuration items.

Portions of this code were derived from IETF RFC 7223.
Please reproduce this note if possible.

IETF code is subject to the following copyright and license:
Copyright (c) IETF Trust and the persons identified as authors of
the code.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, is permitted pursuant to, and subject to the license
terms contained in, the Simplified BSD License set forth in
Section 4.c of the IETF Trust's Legal Provisions Relating
to IETF Documents (http://trustee.ietf.org/license-info).
  """
  __slots__ = ('_path_helper', '_extmethods', '__interfaces',)

  _yang_name = 'openconfig-interfaces'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interfaces = YANGDynClass(base=interfaces.interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /interfaces (container)

    YANG Description: Top level container for interfaces, including configuration
and state data.
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Top level container for interfaces, including configuration
and state data.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=interfaces.interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=interfaces.interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=interfaces.interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('interfaces', interfaces), ])


class openconfig_if_ethernet(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-ethernet - based on the path /openconfig-if-ethernet. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model for managing Ethernet interfaces -- augments the OpenConfig
model for interface configuration and state.
  """
  _pyangbind_elements = {}

  

from . import components
class openconfig_platform(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /openconfig-platform. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines a data model for representing a system
component inventory, which can include hardware or software
elements arranged in an arbitrary structure. The primary
relationship supported by the model is containment, e.g.,
components containing subcomponents.

It is expected that this model reflects every field replacable
unit on the device at a minimum (i.e., additional information
may be supplied about non-replacable components).

Every element in the inventory is termed a 'component' with each
component expected to have a unique name and type, and optionally
a unique system-assigned identifier and FRU number.  The
uniqueness is guaranteed by the system within the device.

Components may have properties defined by the system that are
modeled as a list of key-value pairs. These may or may not be
user-configurable.  The model provides a flag for the system
to optionally indicate which properties are user configurable.

Each component also has a list of 'subcomponents' which are
references to other components. Appearance in a list of
subcomponents indicates a containment relationship as described
above.  For example, a linecard component may have a list of
references to port components that reside on the linecard.

This schema is generic to allow devices to express their own
platform-specific structure.  It may be augmented by additional
component type-specific schemas that provide a common structure
for well-known component types.  In these cases, the system is
expected to populate the common component schema, and may
optionally also represent the component and its properties in the
generic structure.

The properties for each component may include dynamic values,
e.g., in the 'state' part of the schema.  For example, a CPU
component may report its utilization, temperature, or other
physical properties.  The intent is to capture all platform-
specific physical data in one location, including inventory
(presence or absence of a component) and state (physical
attributes or status).
  """
  __slots__ = ('_path_helper', '_extmethods', '__components',)

  _yang_name = 'openconfig-platform'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__components = YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_components(self):
    """
    Getter method for components, mapped from YANG variable /components (container)

    YANG Description: Enclosing container for the components in the system.
    """
    return self.__components
      
  def _set_components(self, v, load=False):
    """
    Setter method for components, mapped from YANG variable /components (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_components is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_components() directly.

    YANG Description: Enclosing container for the components in the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """components must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__components = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_components(self):
    self.__components = YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  components = __builtin__.property(_get_components, _set_components)


  _pyangbind_elements = OrderedDict([('components', components), ])


from . import components
class openconfig_platform_common(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /openconfig-platform-common. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This modules contains common groupings that are used in multiple
components within the platform module.
  """
  __slots__ = ('_path_helper', '_extmethods', '__components',)

  _yang_name = 'openconfig-platform-common'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__components = YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_components(self):
    """
    Getter method for components, mapped from YANG variable /components (container)

    YANG Description: Enclosing container for the components in the system.
    """
    return self.__components
      
  def _set_components(self, v, load=False):
    """
    Setter method for components, mapped from YANG variable /components (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_components is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_components() directly.

    YANG Description: Enclosing container for the components in the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """components must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__components = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_components(self):
    self.__components = YANGDynClass(base=components.components, is_container='container', yang_name="components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  components = __builtin__.property(_get_components, _set_components)


  _pyangbind_elements = OrderedDict([('components', components), ])


class openconfig_platform_port(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-port - based on the path /openconfig-platform-port. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data related to PORT components in the
openconfig-platform model
  """
  _pyangbind_elements = {}

  

