# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/ethernet/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet interface counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_mac_control_frames','__in_mac_pause_frames','__in_oversize_frames','__in_undersize_frames','__in_jabber_frames','__in_fragment_frames','__in_8021q_frames','__in_crc_errors','__in_block_errors','__in_carrier_errors','__in_interrupted_tx','__in_late_collision','__in_mac_errors_rx','__in_single_collision','__in_symbol_error','__in_maxsize_exceeded','__out_mac_control_frames','__out_mac_pause_frames','__out_8021q_frames','__out_mac_errors_tx',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_oversize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_undersize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_jabber_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fragment_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_carrier_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_interrupted_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_late_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mac_errors_rx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_single_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_symbol_error = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__in_maxsize_exceeded = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__out_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_errors_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'ethernet', 'state', 'counters']

  def _get_in_mac_control_frames(self):
    """
    Getter method for in_mac_control_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_control_frames (oc-yang:counter64)

    YANG Description: MAC layer control frames received on the interface
    """
    return self.__in_mac_control_frames
      
  def _set_in_mac_control_frames(self, v, load=False):
    """
    Setter method for in_mac_control_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_control_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_control_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_control_frames() directly.

    YANG Description: MAC layer control frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_control_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_control_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_control_frames(self):
    self.__in_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mac_pause_frames(self):
    """
    Getter method for in_mac_pause_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_pause_frames (oc-yang:counter64)

    YANG Description: MAC layer PAUSE frames received on the interface
    """
    return self.__in_mac_pause_frames
      
  def _set_in_mac_pause_frames(self, v, load=False):
    """
    Setter method for in_mac_pause_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_pause_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_pause_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_pause_frames() directly.

    YANG Description: MAC layer PAUSE frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_pause_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_pause_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_pause_frames(self):
    self.__in_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_oversize_frames(self):
    """
    Getter method for in_oversize_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_oversize_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were
longer than 1518 octets (excluding framing bits,
but including FCS octets) and were otherwise
well formed.
    """
    return self.__in_oversize_frames
      
  def _set_in_oversize_frames(self, v, load=False):
    """
    Setter method for in_oversize_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_oversize_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_oversize_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_oversize_frames() directly.

    YANG Description: The total number of frames received that were
longer than 1518 octets (excluding framing bits,
but including FCS octets) and were otherwise
well formed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_oversize_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_oversize_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_oversize_frames(self):
    self.__in_oversize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_undersize_frames(self):
    """
    Getter method for in_undersize_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_undersize_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were
less than 64 octets long (excluding framing bits,
but including FCS octets) and were otherwise well
formed.
    """
    return self.__in_undersize_frames
      
  def _set_in_undersize_frames(self, v, load=False):
    """
    Setter method for in_undersize_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_undersize_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_undersize_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_undersize_frames() directly.

    YANG Description: The total number of frames received that were
less than 64 octets long (excluding framing bits,
but including FCS octets) and were otherwise well
formed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_undersize_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_undersize_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_undersize_frames(self):
    self.__in_undersize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_jabber_frames(self):
    """
    Getter method for in_jabber_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_jabber_frames (oc-yang:counter64)

    YANG Description: Number of jabber frames received on the
interface.  Jabber frames are typically defined as oversize
frames which also have a bad CRC.  Implementations may use
slightly different definitions of what constitutes a jabber
frame.  Often indicative of a NIC hardware problem.
    """
    return self.__in_jabber_frames
      
  def _set_in_jabber_frames(self, v, load=False):
    """
    Setter method for in_jabber_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_jabber_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_jabber_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_jabber_frames() directly.

    YANG Description: Number of jabber frames received on the
interface.  Jabber frames are typically defined as oversize
frames which also have a bad CRC.  Implementations may use
slightly different definitions of what constitutes a jabber
frame.  Often indicative of a NIC hardware problem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_jabber_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_jabber_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_jabber_frames(self):
    self.__in_jabber_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fragment_frames(self):
    """
    Getter method for in_fragment_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_fragment_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were less than
64 octets in length (excluding framing bits but including
FCS octets) and had either a bad Frame Check Sequence
(FCS) with an integral number of octets (FCS Error) or a
bad FCS with a non-integral number of octets (Alignment
Error).
    """
    return self.__in_fragment_frames
      
  def _set_in_fragment_frames(self, v, load=False):
    """
    Setter method for in_fragment_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_fragment_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fragment_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fragment_frames() directly.

    YANG Description: The total number of frames received that were less than
64 octets in length (excluding framing bits but including
FCS octets) and had either a bad Frame Check Sequence
(FCS) with an integral number of octets (FCS Error) or a
bad FCS with a non-integral number of octets (Alignment
Error).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fragment_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fragment_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fragment_frames(self):
    self.__in_fragment_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_8021q_frames(self):
    """
    Getter method for in_8021q_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_8021q_frames (oc-yang:counter64)

    YANG Description: Number of 802.1q tagged frames received on the interface
    """
    return self.__in_8021q_frames
      
  def _set_in_8021q_frames(self, v, load=False):
    """
    Setter method for in_8021q_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_8021q_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_8021q_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_8021q_frames() directly.

    YANG Description: Number of 802.1q tagged frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_8021q_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_8021q_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_8021q_frames(self):
    self.__in_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_crc_errors(self):
    """
    Getter method for in_crc_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_crc_errors (oc-yang:counter64)

    YANG Description: The total number of frames received that
had a length (excluding framing bits, but
including FCS octets) of between 64 and 1518
octets, inclusive, but had either a bad
Frame Check Sequence (FCS) with an integral
number of octets (FCS Error) or a bad FCS with
a non-integral number of octets (Alignment Error)
    """
    return self.__in_crc_errors
      
  def _set_in_crc_errors(self, v, load=False):
    """
    Setter method for in_crc_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_crc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_crc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_crc_errors() directly.

    YANG Description: The total number of frames received that
had a length (excluding framing bits, but
including FCS octets) of between 64 and 1518
octets, inclusive, but had either a bad
Frame Check Sequence (FCS) with an integral
number of octets (FCS Error) or a bad FCS with
a non-integral number of octets (Alignment Error)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_crc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_crc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_crc_errors(self):
    self.__in_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_block_errors(self):
    """
    Getter method for in_block_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_block_errors (oc-yang:counter64)

    YANG Description: The number of received errored blocks. Error detection codes
are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    return self.__in_block_errors
      
  def _set_in_block_errors(self, v, load=False):
    """
    Setter method for in_block_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_block_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_block_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_block_errors() directly.

    YANG Description: The number of received errored blocks. Error detection codes
are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_block_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_block_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_block_errors(self):
    self.__in_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_carrier_errors(self):
    """
    Getter method for in_carrier_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_carrier_errors (oc-yang:counter64)

    YANG Description: The number of received errored frames due to a carrier issue.
The value refers to MIB counter for
dot3StatsCarrierSenseErrors
oid=1.3.6.1.2.1.10.7.2.1.11
    """
    return self.__in_carrier_errors
      
  def _set_in_carrier_errors(self, v, load=False):
    """
    Setter method for in_carrier_errors, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_carrier_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_carrier_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_carrier_errors() directly.

    YANG Description: The number of received errored frames due to a carrier issue.
The value refers to MIB counter for
dot3StatsCarrierSenseErrors
oid=1.3.6.1.2.1.10.7.2.1.11
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_carrier_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_carrier_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_carrier_errors(self):
    self.__in_carrier_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_interrupted_tx(self):
    """
    Getter method for in_interrupted_tx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_interrupted_tx (oc-yang:counter64)

    YANG Description: The number of received errored frames due to interrupted
transmission issue. The value refers to MIB counter for
dot3StatsDeferredTransmissions
oid=1.3.6.1.2.1.10.7.2.1.7
    """
    return self.__in_interrupted_tx
      
  def _set_in_interrupted_tx(self, v, load=False):
    """
    Setter method for in_interrupted_tx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_interrupted_tx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_interrupted_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_interrupted_tx() directly.

    YANG Description: The number of received errored frames due to interrupted
transmission issue. The value refers to MIB counter for
dot3StatsDeferredTransmissions
oid=1.3.6.1.2.1.10.7.2.1.7
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_interrupted_tx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_interrupted_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_interrupted_tx(self):
    self.__in_interrupted_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_late_collision(self):
    """
    Getter method for in_late_collision, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_late_collision (oc-yang:counter64)

    YANG Description: The number of received errored frames due to late collision
issue. The value refers to MIB counter for
dot3StatsLateCollisions
oid=1.3.6.1.2.1.10.7.2.1.8
    """
    return self.__in_late_collision
      
  def _set_in_late_collision(self, v, load=False):
    """
    Setter method for in_late_collision, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_late_collision (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_late_collision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_late_collision() directly.

    YANG Description: The number of received errored frames due to late collision
issue. The value refers to MIB counter for
dot3StatsLateCollisions
oid=1.3.6.1.2.1.10.7.2.1.8
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_late_collision must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_late_collision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_late_collision(self):
    self.__in_late_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mac_errors_rx(self):
    """
    Getter method for in_mac_errors_rx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_errors_rx (oc-yang:counter64)

    YANG Description: The number of received errored frames due to MAC errors
received. The value refers to MIB counter for
dot3StatsInternalMacReceiveErrors
oid=1.3.6.1.2.1.10.7.2.1.16
    """
    return self.__in_mac_errors_rx
      
  def _set_in_mac_errors_rx(self, v, load=False):
    """
    Setter method for in_mac_errors_rx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_mac_errors_rx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_errors_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_errors_rx() directly.

    YANG Description: The number of received errored frames due to MAC errors
received. The value refers to MIB counter for
dot3StatsInternalMacReceiveErrors
oid=1.3.6.1.2.1.10.7.2.1.16
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_errors_rx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_errors_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_errors_rx(self):
    self.__in_mac_errors_rx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_single_collision(self):
    """
    Getter method for in_single_collision, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_single_collision (oc-yang:counter64)

    YANG Description: The number of received errored frames due to single collision
issue. The value refers to MIB counter for
dot3StatsSingleCollisionFrames
oid=1.3.6.1.2.1.10.7.2.1.4
    """
    return self.__in_single_collision
      
  def _set_in_single_collision(self, v, load=False):
    """
    Setter method for in_single_collision, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_single_collision (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_single_collision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_single_collision() directly.

    YANG Description: The number of received errored frames due to single collision
issue. The value refers to MIB counter for
dot3StatsSingleCollisionFrames
oid=1.3.6.1.2.1.10.7.2.1.4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_single_collision must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_single_collision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_single_collision(self):
    self.__in_single_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_symbol_error(self):
    """
    Getter method for in_symbol_error, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_symbol_error (oc-yang:counter64)

    YANG Description: The number of received errored frames due to symbol error.
The value refers to MIB counter for
in-symbol-error
oid=1.3.6.1.2.1.10.7.2.1.18
    """
    return self.__in_symbol_error
      
  def _set_in_symbol_error(self, v, load=False):
    """
    Setter method for in_symbol_error, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_symbol_error (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_symbol_error is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_symbol_error() directly.

    YANG Description: The number of received errored frames due to symbol error.
The value refers to MIB counter for
in-symbol-error
oid=1.3.6.1.2.1.10.7.2.1.18
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_symbol_error must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_symbol_error = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_symbol_error(self):
    self.__in_symbol_error = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_maxsize_exceeded(self):
    """
    Getter method for in_maxsize_exceeded, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_maxsize_exceeded (oc-yang:counter64)

    YANG Description: The total number frames received that are well-formed but
dropped due to exceeding the maximum frame size on the interface
(e.g., MTU or MRU)
    """
    return self.__in_maxsize_exceeded
      
  def _set_in_maxsize_exceeded(self, v, load=False):
    """
    Setter method for in_maxsize_exceeded, mapped from YANG variable /interfaces/interface/ethernet/state/counters/in_maxsize_exceeded (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_maxsize_exceeded is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_maxsize_exceeded() directly.

    YANG Description: The total number frames received that are well-formed but
dropped due to exceeding the maximum frame size on the interface
(e.g., MTU or MRU)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_maxsize_exceeded must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_maxsize_exceeded = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_maxsize_exceeded(self):
    self.__in_maxsize_exceeded = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_control_frames(self):
    """
    Getter method for out_mac_control_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_control_frames (oc-yang:counter64)

    YANG Description: MAC layer control frames sent on the interface
    """
    return self.__out_mac_control_frames
      
  def _set_out_mac_control_frames(self, v, load=False):
    """
    Setter method for out_mac_control_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_control_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_control_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_control_frames() directly.

    YANG Description: MAC layer control frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_control_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_control_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_control_frames(self):
    self.__out_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_pause_frames(self):
    """
    Getter method for out_mac_pause_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_pause_frames (oc-yang:counter64)

    YANG Description: MAC layer PAUSE frames sent on the interface
    """
    return self.__out_mac_pause_frames
      
  def _set_out_mac_pause_frames(self, v, load=False):
    """
    Setter method for out_mac_pause_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_pause_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_pause_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_pause_frames() directly.

    YANG Description: MAC layer PAUSE frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_pause_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_pause_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_pause_frames(self):
    self.__out_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_8021q_frames(self):
    """
    Getter method for out_8021q_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_8021q_frames (oc-yang:counter64)

    YANG Description: Number of 802.1q tagged frames sent on the interface
    """
    return self.__out_8021q_frames
      
  def _set_out_8021q_frames(self, v, load=False):
    """
    Setter method for out_8021q_frames, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_8021q_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_8021q_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_8021q_frames() directly.

    YANG Description: Number of 802.1q tagged frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_8021q_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_8021q_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_8021q_frames(self):
    self.__out_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_errors_tx(self):
    """
    Getter method for out_mac_errors_tx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_errors_tx (oc-yang:counter64)

    YANG Description: The number of sent errored frames due to MAC errors
transmitted. The value refers to MIB counter for
dot3StatsInternalMacTransmitErrors
oid=1.3.6.1.2.1.10.7.2.1.10
    """
    return self.__out_mac_errors_tx
      
  def _set_out_mac_errors_tx(self, v, load=False):
    """
    Setter method for out_mac_errors_tx, mapped from YANG variable /interfaces/interface/ethernet/state/counters/out_mac_errors_tx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_errors_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_errors_tx() directly.

    YANG Description: The number of sent errored frames due to MAC errors
transmitted. The value refers to MIB counter for
dot3StatsInternalMacTransmitErrors
oid=1.3.6.1.2.1.10.7.2.1.10
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_errors_tx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_errors_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_errors_tx(self):
    self.__out_mac_errors_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces/ethernet', defining_module='openconfig-if-ethernet', yang_type='oc-yang:counter64', is_config=False)

  in_mac_control_frames = __builtin__.property(_get_in_mac_control_frames)
  in_mac_pause_frames = __builtin__.property(_get_in_mac_pause_frames)
  in_oversize_frames = __builtin__.property(_get_in_oversize_frames)
  in_undersize_frames = __builtin__.property(_get_in_undersize_frames)
  in_jabber_frames = __builtin__.property(_get_in_jabber_frames)
  in_fragment_frames = __builtin__.property(_get_in_fragment_frames)
  in_8021q_frames = __builtin__.property(_get_in_8021q_frames)
  in_crc_errors = __builtin__.property(_get_in_crc_errors)
  in_block_errors = __builtin__.property(_get_in_block_errors)
  in_carrier_errors = __builtin__.property(_get_in_carrier_errors)
  in_interrupted_tx = __builtin__.property(_get_in_interrupted_tx)
  in_late_collision = __builtin__.property(_get_in_late_collision)
  in_mac_errors_rx = __builtin__.property(_get_in_mac_errors_rx)
  in_single_collision = __builtin__.property(_get_in_single_collision)
  in_symbol_error = __builtin__.property(_get_in_symbol_error)
  in_maxsize_exceeded = __builtin__.property(_get_in_maxsize_exceeded)
  out_mac_control_frames = __builtin__.property(_get_out_mac_control_frames)
  out_mac_pause_frames = __builtin__.property(_get_out_mac_pause_frames)
  out_8021q_frames = __builtin__.property(_get_out_8021q_frames)
  out_mac_errors_tx = __builtin__.property(_get_out_mac_errors_tx)


  _pyangbind_elements = OrderedDict([('in_mac_control_frames', in_mac_control_frames), ('in_mac_pause_frames', in_mac_pause_frames), ('in_oversize_frames', in_oversize_frames), ('in_undersize_frames', in_undersize_frames), ('in_jabber_frames', in_jabber_frames), ('in_fragment_frames', in_fragment_frames), ('in_8021q_frames', in_8021q_frames), ('in_crc_errors', in_crc_errors), ('in_block_errors', in_block_errors), ('in_carrier_errors', in_carrier_errors), ('in_interrupted_tx', in_interrupted_tx), ('in_late_collision', in_late_collision), ('in_mac_errors_rx', in_mac_errors_rx), ('in_single_collision', in_single_collision), ('in_symbol_error', in_symbol_error), ('in_maxsize_exceeded', in_maxsize_exceeded), ('out_mac_control_frames', out_mac_control_frames), ('out_mac_pause_frames', out_mac_pause_frames), ('out_8021q_frames', out_8021q_frames), ('out_mac_errors_tx', out_mac_errors_tx), ])


