# Copyright 2022-2025 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import copy, logging, pytest
from common.Settings import get_setting
from context.client.ContextClient import ContextClient
from common.proto.context_pb2 import Service
from device.client.DeviceClient import DeviceClient
from service.client.ServiceClient import ServiceClient
from tests.p4.tests.Objects import SERVICES

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)


@pytest.fixture(scope='session')
def context_client():
    _client = ContextClient(get_setting('CONTEXTSERVICE_SERVICE_HOST'), get_setting('CONTEXTSERVICE_SERVICE_PORT_GRPC'))
    yield _client
    _client.close()


@pytest.fixture(scope='session')
def device_client():
    _client = DeviceClient(get_setting('DEVICESERVICE_SERVICE_HOST'), get_setting('DEVICESERVICE_SERVICE_PORT_GRPC'))
    yield _client
    _client.close()

@pytest.fixture(scope='session')
def service_client():
    _client = ServiceClient(get_setting('SERVICESERVICE_SERVICE_HOST'), get_setting('SERVICESERVICE_SERVICE_PORT_GRPC'))
    yield _client
    _client.close()

def test_rules_entry(
    context_client : ContextClient, device_client : DeviceClient, service_client : ServiceClient):  # pylint: disable=redefined-outer-name

    # ----- Create Services ---------------------------------------------------------------
    for service, endpoints in SERVICES:
        # Insert Service (table entries)
        service_uuid = service['service_id']['service_uuid']['uuid']
        print('Creating Service {:s}'.format(service_uuid))
        service_p4 = copy.deepcopy(service)
        service_client.CreateService(Service(**service_p4))
        service_p4['service_endpoint_ids'].extend(endpoints)
        service_client.UpdateService(Service(**service_p4))
