#  Copyright 2022-2024 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)

#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at

#       http://www.apache.org/licenses/LICENSE-2.0

#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import grpc
import logging
import sys

sys.path.append('/home/ubuntu/tfs-ctrl/src')


from pcep.service.tools.protos.grpcService_pb2 import LSPdb_Request, Session_Request
from pcep.service.tools.protos.grpcService_pb2_grpc import pceServiceStub
def run():
    # Create a gRPC channel
    # channel = grpc.insecure_channel('localhost:31816')
    channel = grpc.insecure_channel('192.168.159.225:10060')

    # Create a gRPC stub
    stub = pceServiceStub(channel)

    
    #LSPDB
    # Construct a request (LSPDB Request)
    requestlsp = LSPdb_Request()
    # Make the gRPC call
    responselsp = stub.getLSPdb(requestlsp)
    # Print the received response
    print("\nRESPUESTA RECIBIDA")
    print(responselsp)
    
    # Construct a request (Session Request)
    sessionrequest = Session_Request()
    # Make the gRPC call
    sessionresponse = stub.getSessionsInfo(sessionrequest)
    # Print the received response
    print("\nRESPUESTA RECIBIDA")
    print(sessionresponse)
if __name__ == '__main__':
    logging.basicConfig()
    run()
