# Copyright 2022-2024 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from pcep.service.tools.GrpcServer import GrpcServer
from common.Constants import ServiceNameEnum
from common.Settings import get_service_port_grpc, get_service_host
from common.proto.pcep_pb2_grpc import add_PcepServiceServicer_to_server
from common.tools.service.GenericGrpcService import GenericGrpcService
from .PcepServiceServicerImpl import PcepServiceServicerImpl

LOGGER = logging.getLogger(__name__)

class PcepService(GenericGrpcService):
    def __init__(self, pcepServer : GrpcServer,cls_name: str = __name__) -> None:
        port = get_service_port_grpc(ServiceNameEnum.PCEP)                                      #El enum en common.constants
        LOGGER.debug('PORT... (PCEP Service)')
        LOGGER.debug(port)

        host = get_service_host(ServiceNameEnum.PCEP)                                           #El enum en common.constants
        LOGGER.debug('HOST... (PCEP Service)')
        LOGGER.debug(host)
        
        super().__init__(port, cls_name=cls_name)
        self.pcep_servicer = PcepServiceServicerImpl(pcepServer)
        LOGGER.debug('Creating Servicer... (PCEP Service)')

    def install_servicers(self):
        add_PcepServiceServicer_to_server(self.pcep_servicer, self.server)

# class PcepService(GenericGrpcService):
#     def __init__(self, pcepServer: GrpcServer, cls_name: str = __name__) -> None:
#         # Direcciones y puerto fijos
#         host = '192.168.159.225'  # Dirección IP fija
#         port = '10060'  # Puerto fijo

#         LOGGER.debug(f'HOST... (PCEP Service): {host}')
#         LOGGER.debug(f'PORT... (PCEP Service): {port}')

#         # Llamada al constructor de la clase base, pasando el host y el puerto directamente
#         super().__init__(port, cls_name=cls_name)
#         self.pcep_servicer = PcepServiceServicerImpl(pcepServer)
#         LOGGER.debug('Creating Servicer... (PCEP Service)')

#     def install_servicers(self):
#         add_PcepServiceServicer_to_server(self.pcep_servicer, self.server)