import os
import unittest
from sqlalchemy.orm import sessionmaker
from pcep.database.LSP_DB import LspDB, LspModel

# Establecer la variable de entorno dentro de las pruebas
os.environ['CRDB_SQL_PORT'] = '26257'  # Establece el puerto SQL necesario
os.environ['CRDB_SSLMODE'] = 'require'

class TestLspDatabase(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        """
        Esta función se ejecuta una vez antes de todas las pruebas.
        Aquí se puede configurar la base de datos.
        """
        cls.db = LspDB()  # Se conecta a la base de datos real
        
        # Crear la base de datos y las tablas si es necesario
        cls.db.create_database()  # Crea la base de datos si no existe
        cls.db.create_tables()  # Crea las tablas necesarias

    
    def test_select_all_lsp(self):
        """
        Realiza una prueba de selección de todos los registros de la tabla 'lsp'.
        """
        session = self.db.Session()
        try:
            # Ejecutar la consulta SQL directamente
            result = session.execute("SELECT * FROM lsp").fetchall()
            print(result)  # Para ver los resultados en la consola
            self.assertIsInstance(result, list)  # Asegura que el resultado es una lista
            self.assertGreater(len(result), 0)  # Asegura que hay al menos un registro
        finally:
            session.close()  # Cierra la sesión

# Ejecutar las pruebas
if __name__ == '__main__':
    unittest.main()
