import socket

# Define the path to the Unix socket
socket_path = "./tmp/sock"

try:
    # Create a socket object
    server_socket = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)

    # Bind the socket to the socket path
    server_socket.bind(socket_path)

    # Listen for incoming connections
    server_socket.listen(1)

    print(f"Listening on {socket_path}...")

    while True:
        # Accept incoming connection
        connection, client_address = server_socket.accept()

        # Read data from the connection
        data = connection.recv(1024)

        if data:
            print(f"Received: {data.decode()}")

        # Close the connection
        connection.close()

except Exception as e:
    print(f"Error: {str(e)}")
