# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_directive_value import TapiCommonDirectiveValue  # noqa: F401,E501
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationPathOptimizationConstraint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, traffic_interruption: TapiCommonDirectiveValue=None):  # noqa: E501
        """TapiPathComputationPathOptimizationConstraint - a model defined in Swagger

        :param name: The name of this TapiPathComputationPathOptimizationConstraint.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiPathComputationPathOptimizationConstraint.  # noqa: E501
        :type local_id: str
        :param traffic_interruption: The traffic_interruption of this TapiPathComputationPathOptimizationConstraint.  # noqa: E501
        :type traffic_interruption: TapiCommonDirectiveValue
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'traffic_interruption': TapiCommonDirectiveValue
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'traffic_interruption': 'traffic-interruption'
        }
        self._name = name
        self._local_id = local_id
        self._traffic_interruption = traffic_interruption

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationPathOptimizationConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.PathOptimizationConstraint of this TapiPathComputationPathOptimizationConstraint.  # noqa: E501
        :rtype: TapiPathComputationPathOptimizationConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiPathComputationPathOptimizationConstraint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiPathComputationPathOptimizationConstraint.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiPathComputationPathOptimizationConstraint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiPathComputationPathOptimizationConstraint.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiPathComputationPathOptimizationConstraint.

        none  # noqa: E501

        :return: The local_id of this TapiPathComputationPathOptimizationConstraint.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiPathComputationPathOptimizationConstraint.

        none  # noqa: E501

        :param local_id: The local_id of this TapiPathComputationPathOptimizationConstraint.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def traffic_interruption(self) -> TapiCommonDirectiveValue:
        """Gets the traffic_interruption of this TapiPathComputationPathOptimizationConstraint.


        :return: The traffic_interruption of this TapiPathComputationPathOptimizationConstraint.
        :rtype: TapiCommonDirectiveValue
        """
        return self._traffic_interruption

    @traffic_interruption.setter
    def traffic_interruption(self, traffic_interruption: TapiCommonDirectiveValue):
        """Sets the traffic_interruption of this TapiPathComputationPathOptimizationConstraint.


        :param traffic_interruption: The traffic_interruption of this TapiPathComputationPathOptimizationConstraint.
        :type traffic_interruption: TapiCommonDirectiveValue
        """

        self._traffic_interruption = traffic_interruption
