# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_notification_perceived_severity_type import TapiNotificationPerceivedSeverityType  # noqa: F401,E501
from tapi_server.models.tapi_notification_service_affecting import TapiNotificationServiceAffecting  # noqa: F401,E501
from tapi_server import util


class TapiNotificationAlarmInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, perceived_severity: TapiNotificationPerceivedSeverityType=None, probable_cause: str=None, service_affecting: TapiNotificationServiceAffecting=None, is_transient: bool=False):  # noqa: E501
        """TapiNotificationAlarmInfo - a model defined in Swagger

        :param perceived_severity: The perceived_severity of this TapiNotificationAlarmInfo.  # noqa: E501
        :type perceived_severity: TapiNotificationPerceivedSeverityType
        :param probable_cause: The probable_cause of this TapiNotificationAlarmInfo.  # noqa: E501
        :type probable_cause: str
        :param service_affecting: The service_affecting of this TapiNotificationAlarmInfo.  # noqa: E501
        :type service_affecting: TapiNotificationServiceAffecting
        :param is_transient: The is_transient of this TapiNotificationAlarmInfo.  # noqa: E501
        :type is_transient: bool
        """
        self.swagger_types = {
            'perceived_severity': TapiNotificationPerceivedSeverityType,
            'probable_cause': str,
            'service_affecting': TapiNotificationServiceAffecting,
            'is_transient': bool
        }

        self.attribute_map = {
            'perceived_severity': 'perceived-severity',
            'probable_cause': 'probable-cause',
            'service_affecting': 'service-affecting',
            'is_transient': 'is-transient'
        }
        self._perceived_severity = perceived_severity
        self._probable_cause = probable_cause
        self._service_affecting = service_affecting
        self._is_transient = is_transient

    @classmethod
    def from_dict(cls, dikt) -> 'TapiNotificationAlarmInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.notification.AlarmInfo of this TapiNotificationAlarmInfo.  # noqa: E501
        :rtype: TapiNotificationAlarmInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def perceived_severity(self) -> TapiNotificationPerceivedSeverityType:
        """Gets the perceived_severity of this TapiNotificationAlarmInfo.


        :return: The perceived_severity of this TapiNotificationAlarmInfo.
        :rtype: TapiNotificationPerceivedSeverityType
        """
        return self._perceived_severity

    @perceived_severity.setter
    def perceived_severity(self, perceived_severity: TapiNotificationPerceivedSeverityType):
        """Sets the perceived_severity of this TapiNotificationAlarmInfo.


        :param perceived_severity: The perceived_severity of this TapiNotificationAlarmInfo.
        :type perceived_severity: TapiNotificationPerceivedSeverityType
        """

        self._perceived_severity = perceived_severity

    @property
    def probable_cause(self) -> str:
        """Gets the probable_cause of this TapiNotificationAlarmInfo.

        none  # noqa: E501

        :return: The probable_cause of this TapiNotificationAlarmInfo.
        :rtype: str
        """
        return self._probable_cause

    @probable_cause.setter
    def probable_cause(self, probable_cause: str):
        """Sets the probable_cause of this TapiNotificationAlarmInfo.

        none  # noqa: E501

        :param probable_cause: The probable_cause of this TapiNotificationAlarmInfo.
        :type probable_cause: str
        """

        self._probable_cause = probable_cause

    @property
    def service_affecting(self) -> TapiNotificationServiceAffecting:
        """Gets the service_affecting of this TapiNotificationAlarmInfo.


        :return: The service_affecting of this TapiNotificationAlarmInfo.
        :rtype: TapiNotificationServiceAffecting
        """
        return self._service_affecting

    @service_affecting.setter
    def service_affecting(self, service_affecting: TapiNotificationServiceAffecting):
        """Sets the service_affecting of this TapiNotificationAlarmInfo.


        :param service_affecting: The service_affecting of this TapiNotificationAlarmInfo.
        :type service_affecting: TapiNotificationServiceAffecting
        """

        self._service_affecting = service_affecting

    @property
    def is_transient(self) -> bool:
        """Gets the is_transient of this TapiNotificationAlarmInfo.

        none  # noqa: E501

        :return: The is_transient of this TapiNotificationAlarmInfo.
        :rtype: bool
        """
        return self._is_transient

    @is_transient.setter
    def is_transient(self, is_transient: bool):
        """Sets the is_transient of this TapiNotificationAlarmInfo.

        none  # noqa: E501

        :param is_transient: The is_transient of this TapiNotificationAlarmInfo.
        :type is_transient: bool
        """

        self._is_transient = is_transient
